/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.som;

import com.rapidminer.tools.math.som.AdaptationFunction;

public class RitterAdaptation
implements AdaptationFunction {
    private static final long serialVersionUID = 254565250431806677L;
    private double learnRateStart = 0.8;
    private double learnRateEnd = 0.01;
    private double adaptationRadiusStart = 5.0;
    private double adaptationRadiusEnd = 1.0;
    private int lastTime = -1;
    private double learnRateCurrent;
    private double adaptationRadiusCurrent;

    @Override
    public double[] adapt(double[] stimulus, double[] nodeValue, double distanceFromImpact, int time, int maxtime) {
        if (this.lastTime != time) {
            this.lastTime = time;
            this.learnRateCurrent = this.learnRateStart * Math.pow(this.learnRateEnd / this.learnRateStart, (double)time / (double)maxtime);
            this.adaptationRadiusCurrent = this.getAdaptationRadius(time, maxtime);
        }
        double distanceWeightCurrent = Math.exp(-distanceFromImpact * distanceFromImpact / (2.0 * this.adaptationRadiusCurrent * this.adaptationRadiusCurrent));
        double[] weightNew = (double[])nodeValue.clone();
        if (distanceWeightCurrent > 0.5) {
            for (int i = 0; i < weightNew.length; ++i) {
                if (Double.isNaN(stimulus[i])) continue;
                int n = i;
                weightNew[n] = weightNew[n] + this.learnRateCurrent * distanceWeightCurrent * (stimulus[i] - nodeValue[i]);
                if (!(weightNew[i] > 10.0)) continue;
                weightNew[i] = weightNew[i];
            }
        }
        return weightNew;
    }

    @Override
    public double getAdaptationRadius(double[] stimulus, int time, int maxtime) {
        return this.getAdaptationRadius(time, maxtime);
    }

    private double getAdaptationRadius(int time, int maxtime) {
        return this.adaptationRadiusStart * Math.pow(this.adaptationRadiusEnd / this.adaptationRadiusStart, (double)time / (double)maxtime);
    }

    public void setAdaptationRadiusStart(double start) {
        this.adaptationRadiusStart = start;
    }

    public void setAdaptationRadiusEnd(double end) {
        this.adaptationRadiusEnd = end;
    }

    public void setLearnRateStart(double start) {
        this.learnRateStart = start;
    }

    public void setLearnRateEnd(double end) {
        this.learnRateEnd = end;
    }
}

