/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.som;

import com.rapidminer.tools.math.som.DistanceFunction;

public class EuclideanDistance
implements DistanceFunction {
    private static final long serialVersionUID = 1127224325142026906L;

    @Override
    public double getDistance(double[] point1, double[] point2) {
        int i;
        double distance = 0.0;
        for (i = 0; i < point1.length; ++i) {
            double current = point1[i] - point2[i];
            distance += current * current;
        }
        if (!Double.isNaN(distance = Math.sqrt(distance))) {
            return distance;
        }
        distance = 0.0;
        for (i = 0; i < point1.length; ++i) {
            double currentDistance = point1[i] - point2[i];
            if (Double.isNaN(currentDistance)) continue;
            distance += currentDistance * currentDistance;
        }
        return Math.sqrt(distance);
    }

    @Override
    public double getDistance(int[] point1, int[] point2) {
        double distance = 0.0;
        for (int i = 0; i < point1.length; ++i) {
            double diff = point1[i] - point2[i];
            distance += diff * diff;
        }
        distance = Math.sqrt(distance);
        return distance;
    }

    @Override
    public double getDistance(int[] point1, int[] point2, int[] dimensions) {
        double distance = 0.0;
        for (int i = 0; i < point1.length; ++i) {
            int coord1 = point1[i] < 0 ? dimensions[i] + point1[i] : point1[i];
            int coord2 = point2[i] < 0 ? dimensions[i] + point2[i] : point2[i];
            double diff = Math.min(Math.abs(coord1 - coord2), (coord1 + dimensions[i] - coord2) % dimensions[i]);
            distance += diff * diff;
        }
        distance = Math.sqrt(distance);
        return distance;
    }
}

