/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.smoothing;

import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.tools.math.smoothing.BisquareSmoothingKernel;
import com.rapidminer.tools.math.smoothing.EpanechnikovSmoothingKernel;
import com.rapidminer.tools.math.smoothing.ExponentialSmoothingKernel;
import com.rapidminer.tools.math.smoothing.GaussianSmoothingKernel;
import com.rapidminer.tools.math.smoothing.McLainSmoothingKernel;
import com.rapidminer.tools.math.smoothing.RectangularSmoothingKernel;
import com.rapidminer.tools.math.smoothing.SmoothingKernel;
import com.rapidminer.tools.math.smoothing.TriangularSmoothingKernel;
import com.rapidminer.tools.math.smoothing.TricubeSmoothingKernel;
import com.rapidminer.tools.math.smoothing.TriweightSmoothingKernel;
import java.util.LinkedList;
import java.util.List;

public class SmoothingKernels {
    public static final String PARAMETER_SMOOTHING_KERNEL = "smoothing_kernel";
    public static final String[] KERNEL_NAMES = new String[]{"Rectangular", "Triangular", "Epanechnikov", "Bisquare", "Tricube", "Triweight", "Gaussian", "Exponential", "McLain"};
    public static final Class<?>[] KERNEL_CLASSES = new Class[]{RectangularSmoothingKernel.class, TriangularSmoothingKernel.class, EpanechnikovSmoothingKernel.class, BisquareSmoothingKernel.class, TricubeSmoothingKernel.class, TriweightSmoothingKernel.class, GaussianSmoothingKernel.class, ExponentialSmoothingKernel.class, McLainSmoothingKernel.class};

    public static final List<ParameterType> getParameterTypes(ParameterHandler handler) {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_SMOOTHING_KERNEL, "Determines which kernel type is used to calculate the weights of distant examples.", KERNEL_NAMES, 5);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    public static final SmoothingKernel createKernel(ParameterHandler handler) throws OperatorException {
        int chosenKernel = handler.getParameterAsInt(PARAMETER_SMOOTHING_KERNEL);
        try {
            return (SmoothingKernel)KERNEL_CLASSES[chosenKernel].newInstance();
        }
        catch (InstantiationException e) {
            throw new OperatorException("Could not instanciate distance measure " + KERNEL_NAMES[chosenKernel]);
        }
        catch (IllegalAccessException e) {
            throw new OperatorException("Could not instanciate distance measure " + KERNEL_NAMES[chosenKernel]);
        }
    }
}

