/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.similarity.numerical;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.math.similarity.SimilarityMeasure;

public class MaxProductSimilarity
extends SimilarityMeasure {
    private static final long serialVersionUID = -7476444724888001751L;

    @Override
    public double calculateSimilarity(double[] value1, double[] value2) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < value1.length; ++i) {
            double v;
            if (Double.isNaN(value1[i]) || Double.isNaN(value2[i]) || !((v = value2[i] * value1[i]) > max)) continue;
            max = v;
        }
        if (max > 0.0) {
            return max;
        }
        return Double.NaN;
    }

    @Override
    public double calculateDistance(double[] value1, double[] value2) {
        return -this.calculateSimilarity(value1, value2);
    }

    @Override
    public void init(ExampleSet exampleSet) throws OperatorException {
        Tools.onlyNumericalAttributes(exampleSet, "value based similarities");
    }

    public String toString() {
        return "Max product numerical similarity";
    }
}

