/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.similarity.numerical;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.math.similarity.DistanceMeasure;

public class ManhattanDistance
extends DistanceMeasure {
    private static final long serialVersionUID = -6657784365192589335L;

    @Override
    public double calculateDistance(double[] value1, double[] value2) {
        double sum = 0.0;
        int counter = 0;
        for (int i = 0; i < value1.length; ++i) {
            if (Double.isNaN(value1[i]) || Double.isNaN(value2[i])) continue;
            sum += Math.abs(value1[i] - value2[i]);
            ++counter;
        }
        double d = sum;
        if (counter > 0) {
            return d;
        }
        return Double.NaN;
    }

    @Override
    public double calculateSimilarity(double[] value1, double[] value2) {
        return -this.calculateDistance(value1, value2);
    }

    @Override
    public void init(ExampleSet exampleSet) throws OperatorException {
        Tools.onlyNumericalAttributes(exampleSet, "value based similarities");
    }

    public String toString() {
        return "Manhattan distance";
    }
}

