/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.similarity.numerical;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.tools.math.kernels.Kernel;
import com.rapidminer.tools.math.similarity.DistanceMeasure;

public class KernelEuclideanDistance
extends DistanceMeasure {
    private static final long serialVersionUID = 6764039884618489619L;
    private Kernel kernel;

    @Override
    public double calculateDistance(double[] value1, double[] value2) {
        return this.kernel.calculateDistance(value1, value1) + this.kernel.calculateDistance(value2, value2) - 2.0 * this.kernel.calculateDistance(value1, value2);
    }

    @Override
    public double calculateSimilarity(double[] value1, double[] value2) {
        return -this.calculateDistance(value1, value2);
    }

    @Override
    public void init(ExampleSet exampleSet) throws OperatorException {
        Tools.onlyNumericalAttributes(exampleSet, "value based similarities");
    }

    public void init(ParameterHandler handler) throws OperatorException {
        this.kernel = Kernel.createKernel(handler);
    }

    public String toString() {
        return "Kernelspace euclidean distance";
    }
}

