/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.similarity.numerical;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.math.similarity.SimilarityMeasure;

public class InnerProductSimilarity
extends SimilarityMeasure {
    private static final long serialVersionUID = -2564011779440607379L;

    @Override
    public double calculateSimilarity(double[] value1, double[] value2) {
        double sum = 0.0;
        for (int i = 0; i < value1.length; ++i) {
            double v1 = value1[i];
            double v2 = value2[i];
            if (Double.isNaN(v1) || Double.isNaN(v2)) continue;
            sum += v2 * v1;
        }
        return sum;
    }

    @Override
    public double calculateDistance(double[] value1, double[] value2) {
        return -this.calculateSimilarity(value1, value2);
    }

    @Override
    public void init(ExampleSet exampleSet) throws OperatorException {
        Tools.onlyNumericalAttributes(exampleSet, "value based similarities");
    }

    public String toString() {
        return "Inner product similarity";
    }
}

