/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.similarity.numerical;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.math.similarity.SimilarityMeasure;

public class CosineSimilarity
extends SimilarityMeasure {
    private static final long serialVersionUID = 2856052490402674777L;

    @Override
    public double calculateSimilarity(double[] value1, double[] value2) {
        double sum = 0.0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int i = 0; i < value1.length; ++i) {
            double v1 = value1[i];
            double v2 = value2[i];
            if (Double.isNaN(v1) || Double.isNaN(v2)) continue;
            sum += v2 * v1;
            sum1 += v1 * v1;
            sum2 += v2 * v2;
        }
        if (sum1 > 0.0 && sum2 > 0.0) {
            double result = sum / (Math.sqrt(sum1) * Math.sqrt(sum2));
            return Math.min(Math.max(result, -1.0), 1.0);
        }
        if (sum1 == 0.0 && sum2 == 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public double calculateDistance(double[] value1, double[] value2) {
        return Math.acos(this.calculateSimilarity(value1, value2));
    }

    @Override
    public void init(ExampleSet exampleSet) throws OperatorException {
        Tools.onlyNumericalAttributes(exampleSet, "value based similarities");
    }

    public String toString() {
        return "Cosine similarity";
    }
}

