/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.similarity.numerical;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.math.similarity.DistanceMeasure;

public class ChebychevNumericalDistance
extends DistanceMeasure {
    private static final long serialVersionUID = -2995153254013795660L;

    @Override
    public double calculateDistance(double[] value1, double[] value2) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < value1.length; ++i) {
            double d;
            double v1 = value1[i];
            double v2 = value2[i];
            if (Double.isNaN(v1) || Double.isNaN(v2) || !((d = Math.abs(v1 - v2)) > max)) continue;
            max = d;
        }
        if (max > Double.NEGATIVE_INFINITY) {
            return max;
        }
        return Double.NaN;
    }

    @Override
    public double calculateSimilarity(double[] value1, double[] value2) {
        return -this.calculateDistance(value1, value2);
    }

    @Override
    public void init(ExampleSet exampleSet) throws OperatorException {
        Tools.onlyNumericalAttributes(exampleSet, "value based similarities");
    }

    public String toString() {
        return "Chebychev numerical distance";
    }
}

