/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.similarity.nominal;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.tools.math.similarity.DistanceMeasure;

public class NominalDistance
extends DistanceMeasure {
    private static final long serialVersionUID = -1239573851325335924L;

    @Override
    public double calculateDistance(double[] value1, double[] value2) {
        double sum = 0.0;
        int counter = 0;
        for (int i = 0; i < value1.length; ++i) {
            if (Double.isNaN(value1[i]) || Double.isNaN(value2[i])) continue;
            if (value1[i] != value2[i]) {
                sum += 1.0;
            }
            ++counter;
        }
        if (counter > 0) {
            return sum;
        }
        return Double.NaN;
    }

    @Override
    public double calculateSimilarity(double[] value1, double[] value2) {
        return -this.calculateDistance(value1, value2);
    }

    @Override
    public void init(ExampleSet exampleSet) {
    }

    public String toString() {
        return "Nominal distance";
    }
}

