/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.similarity.mixed;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.tools.math.similarity.DistanceMeasure;

public class MixedEuclideanDistance
extends DistanceMeasure {
    private static final long serialVersionUID = 536655587492508882L;
    private boolean[] isNominal;

    @Override
    public double calculateDistance(double[] value1, double[] value2) {
        double sum = 0.0;
        int counter = 0;
        for (int i = 0; i < value1.length; ++i) {
            if (Double.isNaN(value1[i]) || Double.isNaN(value2[i])) continue;
            if (this.isNominal[i]) {
                if (value1[i] != value2[i]) {
                    sum += 1.0;
                }
            } else {
                double diff = value1[i] - value2[i];
                sum += diff * diff;
            }
            ++counter;
        }
        if (counter > 0) {
            return Math.sqrt(sum);
        }
        return Double.NaN;
    }

    @Override
    public double calculateSimilarity(double[] value1, double[] value2) {
        return -this.calculateDistance(value1, value2);
    }

    @Override
    public void init(ExampleSet exampleSet) {
        this.isNominal = new boolean[exampleSet.getAttributes().size()];
        int index = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            this.isNominal[index++] = attribute.isNominal();
        }
    }

    public String toString() {
        return "Mixed euclidean distance";
    }
}

