/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.similarity.divergences;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.math.similarity.BregmanDivergence;

public class KLDivergence
extends BregmanDivergence {
    private static final long serialVersionUID = -2151832592670074328L;

    @Override
    public double calculateDistance(double[] value1, double[] value2) {
        double result = 0.0;
        for (int i = 0; i < value1.length; ++i) {
            result += value1[i] * this.logXToBaseY(value1[i] / value2[i], 2.0);
        }
        return result;
    }

    @Override
    public void init(ExampleSet exampleSet) throws OperatorException {
        Tools.onlyNumericalAttributes(exampleSet, "value based similarities");
    }

    public String toString() {
        return "Kullback-Leibler divergence";
    }
}

