/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.similarity.divergences;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.math.similarity.BregmanDivergence;

public class GeneralizedIDivergence
extends BregmanDivergence {
    private static final long serialVersionUID = 5638471495692639837L;

    @Override
    public double calculateDistance(double[] value1, double[] value2) {
        double result = 0.0;
        double result2 = 0.0;
        for (int i = 0; i < value1.length; ++i) {
            result += value1[i] * Math.log(value1[i] / value2[i]);
            result2 += value1[i] - value2[i];
        }
        return result -= result2;
    }

    @Override
    public void init(ExampleSet exampleSet) throws OperatorException {
        Tools.onlyNumericalAttributes(exampleSet, "value based similarities");
        Attributes attributes = exampleSet.getAttributes();
        for (Example example : exampleSet) {
            for (Attribute attribute : attributes) {
                if (!(example.getValue(attribute) <= 0.0)) continue;
                throw new OperatorException("The bregman divergence you've choosen is not applicable for the dataset! Proceeding with the 'Squared Euclidean distance' bregman divergence.");
            }
        }
    }

    public String toString() {
        return "generalized I-divergence";
    }
}

