/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.similarity;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import com.rapidminer.tools.math.similarity.DistanceMeasures;

public class DistanceMeasureHelper {
    private Operator operator;
    private DistanceMeasure measure;

    public DistanceMeasureHelper(Operator operator) {
        this.operator = operator;
        operator.getParameters().addObserver(new Observer<String>(){

            @Override
            public void update(Observable<String> observable, String arg) {
                if ("measure_types".equals(arg) || "mixed_measure".equals(arg) || "numerical_measure".equals(arg) || "nominal_measure".equals(arg) || "divergence".equals(arg)) {
                    DistanceMeasureHelper.this.updateMeasure();
                }
            }
        }, false);
        this.updateMeasure();
    }

    private void updateMeasure() {
        if (this.measure != null) {
            this.measure.uninstallAdditionalPorts(this.operator.getInputPorts());
        }
        try {
            this.measure = DistanceMeasures.createMeasure(this.operator);
        }
        catch (UndefinedParameterError e) {
            this.operator.getLog().log("While updating distance measute: " + e.toString(), 6);
        }
        catch (OperatorException e) {
            this.operator.getLog().log("While updating distance measute: " + e.toString(), 6);
        }
        if (this.measure != null) {
            this.measure.installAdditionalPorts(this.operator.getInputPorts(), this.operator);
        }
    }

    public DistanceMeasure getInitializedMeasure(ExampleSet exampleSet) throws OperatorException {
        this.measure.init(exampleSet, this.operator);
        return this.measure;
    }

    public int getSelectedMeasureType() throws UndefinedParameterError {
        return DistanceMeasures.getSelectedMeasureType(this.operator);
    }
}

