/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.similarity;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.parameter.ParameterHandler;
import java.io.Serializable;

public abstract class DistanceMeasure
implements Serializable {
    private static final long serialVersionUID = 1290079829430640414L;

    public abstract void init(ExampleSet var1) throws OperatorException;

    public void init(ExampleSet exampleSet, ParameterHandler parameterHandler) throws OperatorException {
        this.init(exampleSet);
    }

    public abstract double calculateDistance(double[] var1, double[] var2);

    public abstract double calculateSimilarity(double[] var1, double[] var2);

    public boolean isDistance() {
        return true;
    }

    public final boolean isSimilarity() {
        return !this.isDistance();
    }

    public double calculateDistance(Example firstExample, Example secondExample) {
        Attributes attributes = firstExample.getAttributes();
        double[] firstValues = new double[attributes.size()];
        double[] secondValues = new double[attributes.size()];
        int i = 0;
        for (Attribute attribute : attributes) {
            firstValues[i] = firstExample.getValue(attribute);
            secondValues[i] = secondExample.getValue(attribute);
            ++i;
        }
        return this.calculateDistance(firstValues, secondValues);
    }

    public final double calculateDistance(Example firstExample, double[] second) {
        Attributes attributes = firstExample.getAttributes();
        double[] firstValues = new double[attributes.size()];
        int i = 0;
        for (Attribute attribute : attributes) {
            firstValues[i] = firstExample.getValue(attribute);
            ++i;
        }
        return this.calculateDistance(firstValues, second);
    }

    public double calculateSimilarity(Example firstExample, Example secondExample) {
        Attributes attributes = firstExample.getAttributes();
        double[] firstValues = new double[attributes.size()];
        double[] secondValues = new double[attributes.size()];
        int i = 0;
        for (Attribute attribute : attributes) {
            firstValues[i] = firstExample.getValue(attribute);
            secondValues[i] = secondExample.getValue(attribute);
            ++i;
        }
        return this.calculateSimilarity(firstValues, secondValues);
    }

    public final double calculateSimilarity(Example firstExample, double[] second) {
        Attributes attributes = firstExample.getAttributes();
        double[] firstValues = new double[attributes.size()];
        int i = 0;
        for (Attribute attribute : attributes) {
            firstValues[i] = firstExample.getValue(attribute);
            ++i;
        }
        return this.calculateSimilarity(firstValues, second);
    }

    public void installAdditionalPorts(InputPorts inputPorts, ParameterHandler parameterHandler) {
    }

    public void uninstallAdditionalPorts(InputPorts inputPorts) {
    }
}

