/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.optimization.ec.es;

import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.math.optimization.ec.es.GaussianMutation;
import com.rapidminer.tools.math.optimization.ec.es.Population;
import com.rapidminer.tools.math.optimization.ec.es.PopulationOperator;
import java.util.Iterator;
import java.util.LinkedList;

public class VarianceAdaption
implements PopulationOperator {
    private static final int WAIT_INTERVALS = 2;
    private static final double FACTOR = 0.85;
    private GaussianMutation mutation = null;
    private int intervalSize;
    private LinkedList<Boolean> successList = new LinkedList();
    private LoggingHandler logging;

    public VarianceAdaption(GaussianMutation mutation, int intervalSize, LoggingHandler logging) {
        this.mutation = mutation;
        this.intervalSize = intervalSize;
        this.logging = logging;
    }

    @Override
    public void operate(Population population) {
        if (population.getGenerationsWithoutImprovement() < 2) {
            this.successList.add(true);
        } else {
            this.successList.add(false);
        }
        if (population.getGeneration() >= 2 * this.intervalSize) {
            this.successList.removeFirst();
            if (population.getGeneration() % this.intervalSize == 0) {
                int successCount = 0;
                Iterator i = this.successList.iterator();
                while (i.hasNext()) {
                    if (!((Boolean)i.next()).booleanValue()) continue;
                    ++successCount;
                }
                if ((double)successCount / (double)(2 * this.intervalSize) < 0.2) {
                    double[] sigma = this.mutation.getSigma();
                    int s = 0;
                    while (s < sigma.length) {
                        int n = s++;
                        sigma[n] = sigma[n] * 0.85;
                    }
                    this.mutation.setSigma(sigma);
                    this.logging.log("Applying 1/5-rule: shrink variance!");
                } else {
                    double[] sigma = this.mutation.getSigma();
                    int s = 0;
                    while (s < sigma.length) {
                        int n = s++;
                        sigma[n] = sigma[n] / 0.85;
                    }
                    this.mutation.setSigma(sigma);
                    this.logging.log("Applying 1/5-rule: enlarge variance!");
                }
            }
        }
    }
}

