/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.optimization.ec.es;

import com.rapidminer.tools.math.optimization.ec.es.Individual;
import com.rapidminer.tools.math.optimization.ec.es.Population;
import com.rapidminer.tools.math.optimization.ec.es.PopulationOperator;
import java.util.LinkedList;
import java.util.Random;

public class TournamentSelection
implements PopulationOperator {
    private double popSize;
    private double tournamentFraction;
    private boolean keepBest = false;
    private Random random;

    public TournamentSelection(int popSize, double tournamentFraction, boolean keepBest, Random random) {
        this.popSize = popSize;
        this.keepBest = keepBest;
        this.tournamentFraction = tournamentFraction;
        this.random = random;
    }

    @Override
    public void operate(Population population) {
        LinkedList<Individual> newGeneration = new LinkedList<Individual>();
        if (population.getNumberOfIndividuals() > 0) {
            int tournamentSize = Math.max((int)Math.round((double)population.getNumberOfIndividuals() * this.tournamentFraction), 1);
            if (this.keepBest && population.getBestEver() != null) {
                newGeneration.add(population.getBestEver());
            }
            while ((double)newGeneration.size() < this.popSize) {
                Individual winner = null;
                for (int k = 0; k < tournamentSize; ++k) {
                    Individual current = population.get(this.random.nextInt(population.getNumberOfIndividuals()));
                    if (winner != null && !(current.getFitnessValues()[0] > winner.getFitnessValues()[0])) continue;
                    winner = current;
                }
                newGeneration.add(winner);
            }
        }
        population.clear();
        population.addAll(newGeneration);
    }
}

