/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.optimization.ec.es;

import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.optimization.ec.es.Individual;
import com.rapidminer.tools.math.optimization.ec.es.Mutation;
import com.rapidminer.tools.math.optimization.ec.es.OptimizationValueType;
import com.rapidminer.tools.math.optimization.ec.es.Population;
import java.util.LinkedList;

public class SparsityMutation
implements Mutation {
    private double prob;
    private double[] min;
    private double[] max;
    private OptimizationValueType[] valueTypes;
    private RandomGenerator random;

    public SparsityMutation(double prob, double[] min, double[] max, OptimizationValueType[] valueTypes, RandomGenerator random) {
        this.prob = prob;
        this.min = min;
        this.max = max;
        this.valueTypes = valueTypes;
        this.random = random;
    }

    @Override
    public void setValueType(int index, OptimizationValueType type) {
        this.valueTypes[index] = type;
    }

    @Override
    public void operate(Population population) {
        LinkedList<Individual> newIndividuals = new LinkedList<Individual>();
        for (int i = 0; i < population.getNumberOfIndividuals(); ++i) {
            Individual clone = (Individual)population.get(i).clone();
            double[] values = clone.getValues();
            boolean changed = false;
            for (int j = 0; j < values.length; ++j) {
                if (!(this.random.nextDouble() < this.prob)) continue;
                changed = true;
                values[j] = values[j] > this.min[j] ? this.min[j] : this.random.nextDoubleInRange(this.min[j], this.max[j]);
                if (this.valueTypes[j].equals((Object)OptimizationValueType.VALUE_TYPE_INT)) {
                    values[j] = (int)Math.round(values[j]);
                    continue;
                }
                if (!this.valueTypes[j].equals((Object)OptimizationValueType.VALUE_TYPE_BOUNDS)) continue;
                values[j] = values[j] >= (this.max[j] - this.min[j]) / 2.0 ? this.min[j] : this.max[j];
            }
            if (!changed) continue;
            clone.setValues(values);
            newIndividuals.add(clone);
        }
        population.addAll(newIndividuals);
    }
}

