/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.optimization.ec.es;

import com.rapidminer.tools.math.optimization.ec.es.Individual;
import com.rapidminer.tools.math.optimization.ec.es.Population;
import com.rapidminer.tools.math.optimization.ec.es.PopulationOperator;
import java.util.LinkedList;
import java.util.Random;

public class RouletteWheel
implements PopulationOperator {
    private int popSize;
    private boolean keepBest;
    private Random random;

    public RouletteWheel(int popSize, boolean keepBest, Random random) {
        this.popSize = popSize;
        this.keepBest = keepBest;
        this.random = random;
    }

    public boolean performOperation(int generation) {
        return true;
    }

    public double filterFitness(double fitness) {
        return fitness;
    }

    @Override
    public void operate(Population population) {
        LinkedList<Individual> newGeneration = new LinkedList<Individual>();
        if (this.keepBest) {
            newGeneration.add(population.getBestEver());
        }
        double fitnessSum = 0.0;
        for (int i = 0; i < population.getNumberOfIndividuals(); ++i) {
            fitnessSum += this.filterFitness(population.get(i).getFitness().getMainCriterion().getFitness());
        }
        while (newGeneration.size() < this.popSize) {
            double r = fitnessSum * this.random.nextDouble();
            int j = 0;
            double f = 0.0;
            Individual individual = null;
            while (j < population.getNumberOfIndividuals() && (f += this.filterFitness((individual = population.get(j++)).getFitness().getMainCriterion().getFitness())) < r) {
            }
            newGeneration.add(individual);
        }
        population.clear();
        population.addAll(newGeneration);
    }
}

