/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.optimization.ec.es;

import com.rapidminer.tools.math.optimization.ec.es.Individual;
import com.rapidminer.tools.math.optimization.ec.es.Population;
import com.rapidminer.tools.math.optimization.ec.es.PopulationOperator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class NonDominatedSortingSelection
implements PopulationOperator {
    private int popSize;

    public NonDominatedSortingSelection(int popSize) {
        this.popSize = popSize;
    }

    @Override
    public void operate(Population population) {
        int index;
        ArrayList<List<Individual>> ranks = new ArrayList<List<Individual>>();
        while (population.getNumberOfIndividuals() > 0) {
            List<Individual> rank = this.getNextRank(population);
            ranks.add(rank);
            Iterator<Individual> i = rank.iterator();
            while (i.hasNext()) {
                population.remove(i.next());
            }
        }
        population.clear();
        for (index = 0; index < ranks.size() && population.getNumberOfIndividuals() + ((List)ranks.get(index)).size() <= this.popSize; ++index) {
            population.addAll((Collection)ranks.get(index));
        }
        if (population.getNumberOfIndividuals() < this.popSize) {
            List rank = (List)ranks.get(index);
            this.sortByCrowdingDistance(rank);
            while (population.getNumberOfIndividuals() < this.popSize) {
                population.add((Individual)rank.remove(0));
            }
        }
    }

    private void sortByCrowdingDistance(List<Individual> rank) {
        Iterator<Individual> f = rank.iterator();
        int numberOfCriteria = 0;
        while (f.hasNext()) {
            Individual current = f.next();
            current.setCrowdingDistance(0.0);
            numberOfCriteria = Math.max(numberOfCriteria, current.getFitnessValues().length);
        }
        for (int m = 0; m < numberOfCriteria; ++m) {
            CriteriaComparator comparator = new CriteriaComparator(m);
            Collections.sort(rank, comparator);
            rank.get(0).setCrowdingDistance(Double.POSITIVE_INFINITY);
            rank.get(rank.size() - 1).setCrowdingDistance(Double.POSITIVE_INFINITY);
            for (int i = 1; i < rank.size() - 1; ++i) {
                Individual current = rank.get(i);
                double currentCrowdingDistance = current.getCrowdingDistance();
                Individual afterI = rank.get(i + 1);
                Individual beforeI = rank.get(i - 1);
                double afterPerformance = afterI.getFitnessValues()[m];
                double beforePerformance = beforeI.getFitnessValues()[m];
                current.setCrowdingDistance(currentCrowdingDistance + Math.abs(afterPerformance - beforePerformance));
            }
        }
        Collections.sort(rank, new CrowdingComparator());
    }

    private List<Individual> getNextRank(Population population) {
        ArrayList<Individual> rank = new ArrayList<Individual>();
        for (int i = 0; i < population.getNumberOfIndividuals(); ++i) {
            Individual current = population.get(i);
            rank.add(current);
            boolean delete = false;
            for (int j = rank.size() - 2; j >= 0; --j) {
                Individual ranked = (Individual)rank.get(j);
                if (NonDominatedSortingSelection.isDominated(ranked, current)) {
                    rank.remove(ranked);
                }
                if (!NonDominatedSortingSelection.isDominated(current, ranked)) continue;
                delete = true;
            }
            if (!delete) continue;
            rank.remove(current);
        }
        return rank;
    }

    public static boolean isDominated(Individual i1, Individual i2) {
        double[] f1 = i1.getFitnessValues();
        double[] f2 = i2.getFitnessValues();
        double[][] performances = new double[f1.length][2];
        for (int p = 0; p < performances.length; ++p) {
            performances[p][0] = f1[p];
            performances[p][1] = f2[p];
        }
        boolean dominated = true;
        for (int p = 0; p < performances.length; ++p) {
            dominated &= performances[p][1] >= performances[p][0];
        }
        boolean oneActuallyBetter = false;
        for (int p = 0; p < performances.length; ++p) {
            oneActuallyBetter |= performances[p][1] > performances[p][0];
        }
        return dominated &= oneActuallyBetter;
    }

    private static class CrowdingComparator
    implements Comparator<Individual>,
    Serializable {
        private static final long serialVersionUID = -3430652527261319675L;

        private CrowdingComparator() {
        }

        @Override
        public int compare(Individual i1, Individual i2) {
            double cd1 = i1.getCrowdingDistance();
            double cd2 = i2.getCrowdingDistance();
            return -1 * Double.compare(cd1, cd2);
        }
    }

    private static class CriteriaComparator
    implements Comparator<Individual>,
    Serializable {
        private static final long serialVersionUID = -959843514627041473L;
        private int m;

        public CriteriaComparator(int m) {
            this.m = m;
        }

        @Override
        public int compare(Individual i1, Individual i2) {
            double[] f1 = i1.getFitnessValues();
            double[] f2 = i2.getFitnessValues();
            return -1 * Double.compare(f1[this.m], f2[this.m]);
        }
    }
}

