/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.optimization.ec.es;

import com.rapidminer.tools.math.optimization.ec.es.Individual;
import com.rapidminer.tools.math.optimization.ec.es.Mutation;
import com.rapidminer.tools.math.optimization.ec.es.OptimizationValueType;
import com.rapidminer.tools.math.optimization.ec.es.Population;
import java.util.LinkedList;
import java.util.Random;

public class GaussianMutation
implements Mutation {
    private double[] sigma;
    private double[] min;
    private double[] max;
    private OptimizationValueType[] valueTypes;
    private Random random;

    public GaussianMutation(double[] sigma, double[] min, double[] max, OptimizationValueType[] valueTypes, Random random) {
        this.sigma = sigma;
        this.min = min;
        this.max = max;
        this.valueTypes = valueTypes;
        this.random = random;
    }

    public void setSigma(double[] sigma) {
        this.sigma = sigma;
    }

    public double[] getSigma() {
        return this.sigma;
    }

    @Override
    public void setValueType(int index, OptimizationValueType type) {
        this.valueTypes[index] = type;
    }

    @Override
    public void operate(Population population) {
        LinkedList<Individual> newIndividuals = new LinkedList<Individual>();
        for (int i = 0; i < population.getNumberOfIndividuals(); ++i) {
            Individual clone = (Individual)population.get(i).clone();
            double[] values = clone.getValues();
            for (int j = 0; j < values.length; ++j) {
                if (this.valueTypes[j].equals((Object)OptimizationValueType.VALUE_TYPE_INT)) {
                    int n = j;
                    values[n] = values[n] + this.random.nextGaussian() * this.sigma[j];
                    values[j] = (int)Math.round(values[j]);
                } else if (this.valueTypes[j].equals((Object)OptimizationValueType.VALUE_TYPE_BOUNDS)) {
                    if (this.random.nextDouble() < 1.0 / (double)values.length) {
                        values[j] = values[j] >= (this.max[j] - this.min[j]) / 2.0 ? this.min[j] : this.max[j];
                    }
                } else {
                    int n = j;
                    values[n] = values[n] + this.random.nextGaussian() * this.sigma[j];
                }
                if (values[j] < this.min[j]) {
                    values[j] = this.min[j];
                }
                if (!(values[j] > this.max[j])) continue;
                values[j] = this.max[j];
            }
            clone.setValues(values);
            newIndividuals.add(clone);
        }
        population.addAll(newIndividuals);
    }
}

