/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.optimization.ec.es;

import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.gui.plotter.SimplePlotterDialog;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeNumber;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.optimization.Optimization;
import com.rapidminer.tools.math.optimization.ec.es.BoltzmannSelection;
import com.rapidminer.tools.math.optimization.ec.es.Crossover;
import com.rapidminer.tools.math.optimization.ec.es.CutSelection;
import com.rapidminer.tools.math.optimization.ec.es.GaussianMutation;
import com.rapidminer.tools.math.optimization.ec.es.Individual;
import com.rapidminer.tools.math.optimization.ec.es.Mutation;
import com.rapidminer.tools.math.optimization.ec.es.NonDominatedSortingSelection;
import com.rapidminer.tools.math.optimization.ec.es.OptimizationValueType;
import com.rapidminer.tools.math.optimization.ec.es.Population;
import com.rapidminer.tools.math.optimization.ec.es.PopulationOperator;
import com.rapidminer.tools.math.optimization.ec.es.PopulationPlotter;
import com.rapidminer.tools.math.optimization.ec.es.RankSelection;
import com.rapidminer.tools.math.optimization.ec.es.RouletteWheel;
import com.rapidminer.tools.math.optimization.ec.es.SparsityMutation;
import com.rapidminer.tools.math.optimization.ec.es.StochasticUniversalSampling;
import com.rapidminer.tools.math.optimization.ec.es.SwitchingMutation;
import com.rapidminer.tools.math.optimization.ec.es.TournamentSelection;
import com.rapidminer.tools.math.optimization.ec.es.UniformSelection;
import com.rapidminer.tools.math.optimization.ec.es.VarianceAdaption;
import java.awt.Dialog;
import java.awt.Window;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ESOptimization
implements Optimization {
    public static final String PARAMETER_MAX_GENERATIONS = "max_generations";
    public static final String PARAMETER_USE_EARLY_STOPPING = "use_early_stopping";
    public static final String PARAMETER_GENERATIONS_WITHOUT_IMPROVAL = "generations_without_improval";
    public static final String PARAMETER_POPULATION_SIZE = "population_size";
    public static final String PARAMETER_TOURNAMENT_FRACTION = "tournament_fraction";
    public static final String PARAMETER_KEEP_BEST = "keep_best";
    public static final String PARAMETER_MUTATION_TYPE = "mutation_type";
    public static final String PARAMETER_SELECTION_TYPE = "selection_type";
    public static final String PARAMETER_CROSSOVER_PROB = "crossover_prob";
    public static final String PARAMETER_SHOW_CONVERGENCE_PLOT = "show_convergence_plot";
    public static final String PARAMETER_SPECIFIY_POPULATION_SIZE = "specify_population_size";
    public static final String[] SELECTION_TYPES = new String[]{"uniform", "cut", "roulette wheel", "stochastic universal sampling", "Boltzmann", "rank", "tournament", "non dominated sorting"};
    public static final int UNIFORM_SELECTION = 0;
    public static final int CUT_SELECTION = 1;
    public static final int ROULETTE_WHEEL = 2;
    public static final int STOCHASTIC_UNIVERSAL = 3;
    public static final int BOLTZMANN_SELECTION = 4;
    public static final int RANK_SELECTION = 5;
    public static final int TOURNAMENT_SELECTION = 6;
    public static final int NON_DOMINATED_SORTING_SELECTION = 7;
    public static final String[] MUTATION_TYPES = new String[]{"none", "gaussian_mutation", "switching_mutation", "sparsity_mutation"};
    public static final int NO_MUTATION = 0;
    public static final int GAUSSIAN_MUTATION = 1;
    public static final int SWITCHING_MUTATION = 2;
    public static final int SPARSITY_MUTATION = 3;
    public static final String[] POPULATION_INIT_TYPES = new String[]{"random", "min", "max"};
    public static final int INIT_TYPE_RANDOM = 0;
    public static final int INIT_TYPE_MIN = 1;
    public static final int INIT_TYPE_MAX = 2;
    public static final int INIT_TYPE_ONE = 3;
    public static final int INIT_TYPE_ZERO = 4;
    private double[] min;
    private double[] max;
    private OptimizationValueType[] valueTypes;
    private int populationSize;
    private int individualSize;
    private int maxGenerations;
    private int generationsWithoutImprovement;
    private int initType = 0;
    private PopulationPlotter populationPlotter = null;
    private Mutation mutation;
    private Population population;
    private Collection<PopulationOperator> popOps;
    private boolean showConvergencePlot = false;
    private AtomicInteger totalEvalCounter = new AtomicInteger();
    private AtomicInteger currentEvalCounter = new AtomicInteger();
    private RandomGenerator random;
    private LoggingHandler logging;
    private Individual currentBest;

    public ESOptimization(double minValue, double maxValue, int populationSize, int individualSize, int initType, int maxGenerations, int generationsWithoutImprovement, int selectionType, double tournamentFraction, boolean keepBest, int mutationType, double crossoverProb, boolean showConvergencePlot, boolean showPopulationPlot, RandomGenerator random, LoggingHandler logging) {
        this(ESOptimization.createBoundArray(minValue, individualSize), ESOptimization.createBoundArray(maxValue, individualSize), populationSize, individualSize, initType, maxGenerations, generationsWithoutImprovement, selectionType, tournamentFraction, keepBest, mutationType, Double.NaN, crossoverProb, showConvergencePlot, showPopulationPlot, random, logging);
    }

    public ESOptimization(double[] minValues, double[] maxValues, int populationSize, int individualSize, int initType, int maxGenerations, int generationsWithoutImprovement, int selectionType, double tournamentFraction, boolean keepBest, int mutationType, double defaultSigma, double crossoverProb, boolean showConvergencePlot, boolean showPopulationPlot, RandomGenerator random, LoggingHandler logging) {
        this.logging = logging;
        this.random = random;
        this.showConvergencePlot = showConvergencePlot;
        this.populationSize = populationSize;
        this.individualSize = individualSize;
        this.min = minValues;
        this.max = maxValues;
        this.valueTypes = new OptimizationValueType[individualSize];
        for (int i = 0; i < this.valueTypes.length; ++i) {
            this.valueTypes[i] = OptimizationValueType.VALUE_TYPE_DOUBLE;
        }
        this.initType = initType;
        this.maxGenerations = maxGenerations;
        this.generationsWithoutImprovement = generationsWithoutImprovement < 1 ? this.maxGenerations : generationsWithoutImprovement;
        this.popOps = new LinkedList<PopulationOperator>();
        switch (selectionType) {
            case 0: {
                this.popOps.add(new UniformSelection(populationSize, keepBest, random));
                break;
            }
            case 1: {
                this.popOps.add(new CutSelection(populationSize));
                break;
            }
            case 2: {
                this.popOps.add(new RouletteWheel(populationSize, keepBest, random));
                break;
            }
            case 3: {
                this.popOps.add(new StochasticUniversalSampling(populationSize, keepBest, random));
                break;
            }
            case 4: {
                this.popOps.add(new BoltzmannSelection(populationSize, 1.0, this.maxGenerations, true, keepBest, random));
                break;
            }
            case 5: {
                this.popOps.add(new RankSelection(populationSize, keepBest, random));
                break;
            }
            case 6: {
                this.popOps.add(new TournamentSelection(populationSize, tournamentFraction, keepBest, random));
                break;
            }
            case 7: {
                this.popOps.add(new NonDominatedSortingSelection(populationSize));
                if (!showPopulationPlot) break;
                this.populationPlotter = new PopulationPlotter();
                this.popOps.add(this.populationPlotter);
            }
        }
        this.popOps.add(new Crossover(crossoverProb, random));
        switch (mutationType) {
            case 1: {
                int s;
                double[] sigma = new double[this.min.length];
                if (!Double.isNaN(defaultSigma)) {
                    for (s = 0; s < sigma.length; ++s) {
                        sigma[s] = defaultSigma;
                    }
                } else {
                    for (s = 0; s < sigma.length; ++s) {
                        sigma[s] = (this.max[s] - this.min[s]) / 100.0;
                    }
                }
                GaussianMutation gm = new GaussianMutation(sigma, this.min, this.max, this.valueTypes, random);
                this.popOps.add(gm);
                this.popOps.add(new VarianceAdaption(gm, individualSize, this.logging));
                this.mutation = gm;
                break;
            }
            case 2: {
                this.mutation = new SwitchingMutation(1.0 / (double)individualSize, this.min, this.max, this.valueTypes, random);
                this.popOps.add(this.mutation);
                break;
            }
            case 3: {
                this.mutation = new SparsityMutation(1.0 / (double)individualSize, this.min, this.max, this.valueTypes, random);
                this.popOps.add(this.mutation);
                break;
            }
        }
    }

    private static double[] createBoundArray(double bound, int size) {
        double[] result = new double[size];
        for (int i = 0; i < result.length; ++i) {
            result[i] = bound;
        }
        return result;
    }

    public abstract PerformanceVector evaluateIndividual(Individual var1) throws OperatorException;

    public void nextIteration() throws OperatorException {
    }

    public double getMin(int index) {
        return this.min[index];
    }

    public double getMax(int index) {
        return this.max[index];
    }

    public void setMin(int index, double v) {
        this.min[index] = v;
    }

    public void setMax(int index, double v) {
        this.max[index] = v;
    }

    public OptimizationValueType getValueType(int index) {
        return this.valueTypes[index];
    }

    public void setValueType(int index, OptimizationValueType type) {
        this.valueTypes[index] = type;
        this.mutation.setValueType(index, type);
    }

    @Override
    public void optimize() throws OperatorException {
        this.totalEvalCounter = new AtomicInteger();
        this.currentEvalCounter = new AtomicInteger();
        switch (this.initType) {
            case 0: {
                this.population = this.createRandomStartPopulation();
                break;
            }
            case 1: {
                this.population = this.createMinStartPopulation();
                break;
            }
            case 2: {
                this.population = this.createMaxStartPopulation();
                break;
            }
            case 3: {
                this.population = this.createFixedStartPopulation(1.0);
                break;
            }
            case 4: {
                this.population = this.createFixedStartPopulation(0.0);
                break;
            }
        }
        this.evaluate(this.population);
        SimpleDataTable dataTable = null;
        Window plotter = null;
        if (this.showConvergencePlot) {
            dataTable = new SimpleDataTable("Fitness vs. Generations", new String[]{"Generations", "Best Fitness", "Current Fitness"});
            plotter = new SimplePlotterDialog(dataTable, false);
            ((SimplePlotterDialog)plotter).setXAxis(0);
            ((SimplePlotterDialog)plotter).plotColumn(1, true);
            ((SimplePlotterDialog)plotter).plotColumn(2, true);
            ((Dialog)plotter).setVisible(true);
            dataTable.add(new SimpleDataTableRow(new double[]{0.0, this.population.getBestEver().getFitness().getMainCriterion().getFitness(), this.population.getCurrentBest().getFitness().getMainCriterion().getFitness()}));
        }
        while (true) {
            if (this.population.getGeneration() >= this.maxGenerations) {
                this.logging.log("ES finished: maximum number of iterations reached.");
                break;
            }
            if (this.population.getGenerationsWithoutImprovement() > this.generationsWithoutImprovement) {
                this.logging.log("ES converged in generation " + this.population.getGeneration() + ": No improvement in last " + this.generationsWithoutImprovement + " generations.");
                break;
            }
            Iterator<PopulationOperator> i = this.popOps.iterator();
            while (i.hasNext()) {
                i.next().operate(this.population);
            }
            this.evaluate(this.population);
            if (this.showConvergencePlot) {
                dataTable.add(new SimpleDataTableRow(new double[]{this.population.getGeneration(), this.population.getBestEver().getFitness().getMainCriterion().getFitness(), this.population.getCurrentBest().getFitness().getMainCriterion().getFitness()}));
            }
            this.population.nextGeneration();
            this.nextIteration();
        }
        if (this.showConvergencePlot) {
            plotter.dispose();
        }
        if (this.populationPlotter != null) {
            this.populationPlotter.setCreateOtherPlottersEnabled(true);
        }
        this.logging.log("ES Evaluations: " + this.currentEvalCounter + " / " + this.totalEvalCounter);
    }

    protected void evaluate(Population population) throws OperatorException {
        this.currentBest = null;
        this.evaluateAll(population);
        if (this.currentBest != null) {
            population.setCurrentBest(this.currentBest);
            Individual bestEver = population.getBestEver();
            if (bestEver == null || this.currentBest.getFitness().getMainCriterion().getFitness() > bestEver.getFitness().getMainCriterion().getFitness()) {
                Individual bestEverClone = (Individual)this.currentBest.clone();
                bestEverClone.setFitness(this.currentBest.getFitness());
                population.setBestEver(bestEverClone);
            }
        }
    }

    protected void evaluateAll(Population population) throws OperatorException {
        for (int i = population.getNumberOfIndividuals() - 1; i >= 0; --i) {
            Individual current = population.get(i);
            if (current.getFitness() == null) {
                this.evaluate(current, population);
            }
            this.totalEvalCounter.incrementAndGet();
        }
    }

    protected void evaluate(Individual current, Population population) throws OperatorException {
        PerformanceVector fitness = this.evaluateIndividual(current);
        if (fitness != null) {
            current.setFitness(fitness);
            if (this.currentBest == null || fitness.getMainCriterion().getFitness() > this.currentBest.getFitness().getMainCriterion().getFitness()) {
                this.currentBest = (Individual)current.clone();
                this.currentBest.setFitness(current.getFitness());
            }
        } else {
            population.remove(current);
        }
        this.currentEvalCounter.incrementAndGet();
    }

    @Override
    public int getGeneration() {
        return this.population.getGeneration();
    }

    @Override
    public double getBestFitnessInGeneration() {
        Individual individual = this.population.getCurrentBest();
        if (individual != null) {
            return individual.getFitnessValues()[0];
        }
        return Double.NaN;
    }

    @Override
    public double getBestFitnessEver() {
        Individual individual = this.population.getBestEver();
        if (individual != null) {
            return individual.getFitnessValues()[0];
        }
        return Double.NaN;
    }

    @Override
    public PerformanceVector getBestPerformanceEver() {
        Individual individual = this.population.getBestEver();
        if (individual != null) {
            return individual.getFitness();
        }
        return null;
    }

    public Population getPopulation() {
        return this.population;
    }

    @Override
    public double[] getBestValuesEver() {
        Individual individual = this.population.getBestEver();
        if (individual != null) {
            return individual.getValues();
        }
        return null;
    }

    private Population createRandomStartPopulation() {
        Population population = new Population();
        for (int p = 0; p < this.populationSize; ++p) {
            double[] alphas = new double[this.individualSize];
            for (int j = 0; j < alphas.length; ++j) {
                if (this.getValueType(j).equals((Object)OptimizationValueType.VALUE_TYPE_INT)) {
                    alphas[j] = (int)Math.round(this.random.nextDoubleInRange(this.min[j], this.max[j]));
                    continue;
                }
                if (this.getValueType(j).equals((Object)OptimizationValueType.VALUE_TYPE_BOUNDS)) {
                    boolean upper = this.random.nextBoolean();
                    if (upper) {
                        alphas[j] = this.max[j];
                        continue;
                    }
                    alphas[j] = this.min[j];
                    continue;
                }
                alphas[j] = this.random.nextDoubleInRange(this.min[j], this.max[j]);
            }
            population.add(new Individual(alphas));
        }
        return population;
    }

    private Population createMinStartPopulation() {
        Population population = new Population();
        for (int p = 0; p < this.populationSize; ++p) {
            double[] alphas = new double[this.individualSize];
            for (int j = 0; j < alphas.length; ++j) {
                alphas[j] = this.min[j];
            }
            population.add(new Individual(alphas));
        }
        return population;
    }

    private Population createMaxStartPopulation() {
        Population population = new Population();
        for (int p = 0; p < this.populationSize; ++p) {
            double[] alphas = new double[this.individualSize];
            for (int j = 0; j < alphas.length; ++j) {
                alphas[j] = this.max[j];
            }
            population.add(new Individual(alphas));
        }
        return population;
    }

    private Population createFixedStartPopulation(double fixedValue) {
        Population population = new Population();
        for (int p = 0; p < this.populationSize; ++p) {
            double[] alphas = new double[this.individualSize];
            for (int j = 0; j < alphas.length; ++j) {
                alphas[j] = fixedValue;
            }
            population.add(new Individual(alphas));
        }
        return population;
    }

    public void increaseCurrentEvaluationCounter() {
        this.currentEvalCounter.incrementAndGet();
    }

    public void increaseTotalEvaluationCounter() {
        this.totalEvalCounter.incrementAndGet();
    }

    public static final List<ParameterType> getParameterTypes(Operator parameterHandler) {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(new ParameterTypeInt(PARAMETER_MAX_GENERATIONS, "Stop after this many evaluations.", 1, Integer.MAX_VALUE, 50, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_EARLY_STOPPING, "Enables early stopping. If unchecked, always the maximum number of generations is performed.", false, false));
        ParameterTypeNumber type = new ParameterTypeInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL, "Stop criterion: Stop after n generations without improval of the performance.", 1, Integer.MAX_VALUE, 2, false);
        type.registerDependencyCondition(new BooleanParameterCondition(parameterHandler, PARAMETER_USE_EARLY_STOPPING, true, true));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_SPECIFIY_POPULATION_SIZE, "If unchecked, one individuum per example of the delivered example set is used.", true, false));
        type = new ParameterTypeInt(PARAMETER_POPULATION_SIZE, "The population size.", 1, Integer.MAX_VALUE, 5, false);
        type.registerDependencyCondition(new BooleanParameterCondition(parameterHandler, PARAMETER_SPECIFIY_POPULATION_SIZE, true, true));
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_BEST, "Indicates if the best individual should survive (elititst selection).", true));
        types.add(new ParameterTypeCategory(PARAMETER_MUTATION_TYPE, "The type of the mutation operator.", MUTATION_TYPES, 1));
        types.add(new ParameterTypeCategory(PARAMETER_SELECTION_TYPE, "The type of the selection operator.", SELECTION_TYPES, 6));
        type = new ParameterTypeDouble(PARAMETER_TOURNAMENT_FRACTION, "The fraction of the population used for tournament selection.", 0.0, Double.POSITIVE_INFINITY, 0.25);
        type.registerDependencyCondition(new EqualTypeCondition(parameterHandler, PARAMETER_SELECTION_TYPE, SELECTION_TYPES, true, 6));
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_CROSSOVER_PROB, "The probability for crossover.", 0.0, 1.0, 0.9));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(parameterHandler));
        types.add(new ParameterTypeBoolean(PARAMETER_SHOW_CONVERGENCE_PLOT, "Indicates if a dialog with a convergence plot should be drawn.", false));
        return types;
    }
}

