/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.matrix;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;

public class CovarianceMatrix {
    public static Matrix getCovarianceMatrix(ExampleSet exampleSet) {
        double[][] data = new double[exampleSet.size()][exampleSet.getAttributes().size()];
        int r = 0;
        for (Example example : exampleSet) {
            int c = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                data[r][c] = example.getValue(attribute);
                ++c;
            }
            ++r;
        }
        return CovarianceMatrix.getCovarianceMatrix(data);
    }

    public static Matrix getCovarianceMatrix(double[][] data) {
        if (data.length == 0) {
            throw new IllegalArgumentException("Calculation of covariance matrices not possible for data sets with zero rows.");
        }
        int numberOfColumns = -1;
        for (int r = 0; r < data.length; ++r) {
            if (numberOfColumns < 0) {
                numberOfColumns = data[r].length;
                continue;
            }
            if (numberOfColumns == data[r].length) continue;
            throw new IllegalArgumentException("Calculation of covariance matrices not possible for data sets with different numbers of columns.");
        }
        if (numberOfColumns <= 0) {
            throw new IllegalArgumentException("Calculation of covariance matrices not possible for data sets with zero columns.");
        }
        for (int c = 0; c < numberOfColumns; ++c) {
            double average = CovarianceMatrix.getAverageForColumn(data, c);
            for (int r = 0; r < data.length; ++r) {
                double[] dArray = data[r];
                int n = c;
                dArray[n] = dArray[n] - average;
            }
        }
        double[][] covarianceMatrixEntries = new double[numberOfColumns][numberOfColumns];
        for (int i = 0; i < covarianceMatrixEntries.length; ++i) {
            for (int j = i; j < covarianceMatrixEntries.length; ++j) {
                double covariance;
                covarianceMatrixEntries[i][j] = covariance = CovarianceMatrix.getCovariance(data, i, j);
                covarianceMatrixEntries[j][i] = covariance;
            }
        }
        return new Matrix(covarianceMatrixEntries);
    }

    private static double getAverageForColumn(double[][] data, int column) {
        double sum = 0.0;
        for (int r = 0; r < data.length; ++r) {
            sum += data[r][column];
        }
        return sum / (double)data.length;
    }

    private static double getCovariance(double[][] data, int x, int y) {
        double cov = 0.0;
        for (int i = 0; i < data.length; ++i) {
            cov += data[i][x] * data[i][y];
        }
        return cov / (double)(data.length - 1);
    }
}

