/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.kernels;

import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.kernels.Kernel;

public class RBFKernel
extends Kernel {
    private static final long serialVersionUID = 2928962529445448574L;
    private double gamma = -1.0;

    @Override
    public int getType() {
        return 1;
    }

    public void setGamma(double gamma) {
        this.gamma = -gamma;
    }

    public double getGamma() {
        return -this.gamma;
    }

    @Override
    public double calculateDistance(double[] x1, double[] x2) {
        return Math.exp(this.gamma * this.norm2(x1, x2));
    }

    @Override
    public String getDistanceFormula(double[] x, String[] attributeConstructions) {
        StringBuffer result = new StringBuffer("exp(");
        result.append(this.gamma + " * (");
        boolean first = true;
        for (int i = 0; i < x.length; ++i) {
            double value = x[i];
            String valueString = "(" + value + " - " + attributeConstructions[i] + ")";
            if (first) {
                result.append(valueString + " * " + valueString);
            } else {
                result.append(" + " + valueString + " * " + valueString);
            }
            first = false;
        }
        result.append("))");
        return result.toString();
    }

    public String toString() {
        return "RBF Kernel with" + Tools.getLineSeparator() + "  gamma: " + Tools.formatNumber(this.getGamma());
    }
}

