/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.kernels;

import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.kernels.Kernel;

public class PolynomialKernel
extends Kernel {
    private static final long serialVersionUID = 1296800822192183260L;
    private double degree = 3.0;
    private double shift = 1.0;

    @Override
    public int getType() {
        return 2;
    }

    public double getDegree() {
        return this.degree;
    }

    public void setPolynomialParameters(double degree, double shift) {
        this.degree = degree;
        this.shift = shift;
    }

    @Override
    public double calculateDistance(double[] x1, double[] x2) {
        double prod;
        double result = prod = this.innerProduct(x1, x2) + this.shift;
        int i = 1;
        while ((double)i < this.degree) {
            result *= prod;
            ++i;
        }
        return result;
    }

    @Override
    public String getDistanceFormula(double[] x, String[] attributeConstructions) {
        StringBuffer innerProductString = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < x.length; ++i) {
            double value = x[i];
            if (Tools.isZero(value)) continue;
            if (value < 0.0) {
                if (first) {
                    innerProductString.append("-" + Math.abs(value) + " * " + attributeConstructions[i]);
                } else {
                    innerProductString.append(" - " + Math.abs(value) + " * " + attributeConstructions[i]);
                }
            } else if (first) {
                innerProductString.append(value + " * " + attributeConstructions[i]);
            } else {
                innerProductString.append(" + " + value + " * " + attributeConstructions[i]);
            }
            first = false;
        }
        StringBuffer result = new StringBuffer("(" + innerProductString.toString() + ")");
        int i = 1;
        while ((double)i < this.degree) {
            result.append(" * (" + innerProductString.toString() + ")");
            ++i;
        }
        return result.toString();
    }

    public String toString() {
        return "Polynomial Kernel with" + Tools.getLineSeparator() + "  shift: " + Tools.formatNumber(this.shift) + Tools.getLineSeparator() + "  degree: " + this.degree;
    }
}

