/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.kernels;

import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.kernels.Kernel;

public class MultiquadricKernel
extends Kernel {
    private static final long serialVersionUID = -7896178642575555770L;
    private double sigma = 1.0;
    private double shift = 1.0;

    @Override
    public int getType() {
        return 7;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setShift(double shift) {
        this.shift = shift;
    }

    public double getShift() {
        return this.shift;
    }

    @Override
    public double calculateDistance(double[] x1, double[] x2) {
        return Math.sqrt(this.norm2(x1, x2) / this.sigma + this.shift * this.shift);
    }

    @Override
    public String getDistanceFormula(double[] x, String[] attributeConstructions) {
        StringBuffer norm2Expression = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < x.length; ++i) {
            double value = x[i];
            String valueString = "(" + value + " - " + attributeConstructions[i] + ")";
            if (first) {
                norm2Expression.append(valueString + " * " + valueString);
            } else {
                norm2Expression.append(" + " + valueString + " * " + valueString);
            }
            first = false;
        }
        return "sqrt((" + norm2Expression + " / " + this.sigma + ") + (" + this.shift + " * " + this.shift + "))";
    }

    public String toString() {
        return "Multiquadric Kernel with" + Tools.getLineSeparator() + "  sigma: " + Tools.formatNumber(this.getSigma()) + Tools.getLineSeparator() + "  shift: " + Tools.formatNumber(this.getShift());
    }
}

