/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.kernels;

import com.rapidminer.tools.math.kernels.KernelCache;
import java.util.HashMap;
import java.util.Map;

public class MapBasedCache
implements KernelCache {
    private int maxSize = 10000000;
    private int exampleSetSize;
    private int accessCounter = 0;
    private Map<Integer, Integer> accessMap;
    private Map<Integer, Double> entries;

    public MapBasedCache(int exampleSetSize) {
        this(10000000, exampleSetSize);
    }

    public MapBasedCache(int maxSize, int exampleSetSize) {
        this.maxSize = maxSize;
        this.exampleSetSize = exampleSetSize;
        this.accessMap = new HashMap<Integer, Integer>(maxSize);
        this.entries = new HashMap<Integer, Double>(maxSize);
    }

    @Override
    public double get(int i, int j) {
        ++this.accessCounter;
        Double result = this.entries.get(i * this.exampleSetSize + j);
        if (result == null) {
            return Double.NaN;
        }
        this.accessMap.put(i * this.exampleSetSize + j, this.accessCounter);
        return result;
    }

    @Override
    public void store(int i, int j, double value) {
        if (this.accessMap.size() > this.maxSize) {
            int oldestKey = -1;
            int oldestAcess = Integer.MAX_VALUE;
            for (Map.Entry<Integer, Integer> entry : this.accessMap.entrySet()) {
                int access = entry.getValue();
                if (access >= oldestAcess) continue;
                oldestKey = entry.getKey();
                oldestAcess = access;
            }
            if (oldestKey != -1) {
                this.accessMap.remove(oldestKey);
                this.entries.remove(oldestKey);
            }
        }
        this.accessMap.put(i * this.exampleSetSize + j, this.accessCounter);
        this.entries.put(i * this.exampleSetSize + j, value);
    }
}

