/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.kernels;

import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.kernels.Kernel;

public class GaussianCombinationKernel
extends Kernel {
    private static final long serialVersionUID = 542405909968243049L;
    private double sigma1 = 1.0;
    private double sigma2 = 0.0;
    private double sigma3 = 2.0;

    @Override
    public int getType() {
        return 6;
    }

    public void setSigma1(double sigma1) {
        this.sigma1 = sigma1;
    }

    public void setSigma2(double sigma2) {
        this.sigma2 = sigma2;
    }

    public void setSigma3(double sigma3) {
        this.sigma3 = sigma3;
    }

    public double getSigma1() {
        return this.sigma1;
    }

    public double getSigma2() {
        return this.sigma2;
    }

    public double getSigma3() {
        return this.sigma3;
    }

    @Override
    public double calculateDistance(double[] x1, double[] x2) {
        double norm2 = this.norm2(x1, x2);
        double exp1 = this.sigma1 == 0.0 ? 0.0 : Math.exp(-1.0 * norm2 / this.sigma1);
        double exp2 = this.sigma2 == 0.0 ? 0.0 : Math.exp(-1.0 * norm2 / this.sigma2);
        double exp3 = this.sigma3 == 0.0 ? 0.0 : Math.exp(-1.0 * norm2 / this.sigma3);
        return exp1 + exp2 - exp3;
    }

    @Override
    public String getDistanceFormula(double[] x, String[] attributeConstructions) {
        StringBuffer norm2Expression = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < x.length; ++i) {
            double value = x[i];
            String valueString = "(" + value + " - " + attributeConstructions[i] + ")";
            if (first) {
                norm2Expression.append(valueString + " * " + valueString);
            } else {
                norm2Expression.append(" + " + valueString + " * " + valueString);
            }
            first = false;
        }
        String exp1 = this.sigma1 == 0.0 ? "" : "exp(-1 * " + norm2Expression.toString() + " / " + this.sigma1 + ")";
        String exp2 = this.sigma2 == 0.0 ? "" : "exp(-1 * " + norm2Expression.toString() + " / " + this.sigma2 + ")";
        String exp3 = this.sigma3 == 0.0 ? "" : "exp(-1 * " + norm2Expression.toString() + " / " + this.sigma3 + ")";
        StringBuffer result = new StringBuffer();
        if (exp1.length() > 0) {
            result.append(exp1);
        }
        if (exp2.length() > 0) {
            if (result.length() > 0) {
                result.append(" + " + exp2);
            } else {
                result.append(exp2);
            }
        }
        if (exp3.length() > 0) {
            if (result.length() > 0) {
                result.append(" - " + exp3);
            } else {
                result.append("-" + exp3);
            }
        }
        return result.toString();
    }

    public String toString() {
        return "GaussianCombination Kernel with" + Tools.getLineSeparator() + "  sigma1: " + Tools.formatNumber(this.getSigma1()) + Tools.getLineSeparator() + "  sigma2: " + Tools.formatNumber(this.getSigma2()) + Tools.getLineSeparator() + "  sigma3: " + Tools.formatNumber(this.getSigma3()) + Tools.getLineSeparator();
    }
}

