/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.kernels;

import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.kernels.Kernel;

public class DotKernel
extends Kernel {
    private static final long serialVersionUID = -7737835520088841652L;

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public double calculateDistance(double[] x1, double[] x2) {
        return this.innerProduct(x1, x2);
    }

    @Override
    public String getDistanceFormula(double[] x, String[] attributeConstructions) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < x.length; ++i) {
            double value = x[i];
            if (Tools.isZero(value)) continue;
            if (value < 0.0) {
                if (first) {
                    result.append("-" + Math.abs(value) + " * " + attributeConstructions[i]);
                } else {
                    result.append(" - " + Math.abs(value) + " * " + attributeConstructions[i]);
                }
            } else if (first) {
                result.append(value + " * " + attributeConstructions[i]);
            } else {
                result.append(" + " + value + " * " + attributeConstructions[i]);
            }
            first = false;
        }
        return result.toString();
    }

    public String toString() {
        return "Dot Kernel";
    }
}

