/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.kernels;

import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.kernels.Kernel;

public class AnovaKernel
extends Kernel {
    private static final long serialVersionUID = -2955083072613762504L;
    private double gamma = -1.0;
    private double degree;

    @Override
    public int getType() {
        return 4;
    }

    public void setGamma(double gamma) {
        this.gamma = -gamma;
    }

    public void setDegree(double degree) {
        this.degree = degree;
    }

    public double getGamma() {
        return -this.gamma;
    }

    @Override
    public double calculateDistance(double[] x1, double[] x2) {
        double result = 0.0;
        int zeros = x1.length;
        for (int i = 0; i < x1.length; ++i) {
            double factor = x1[i] - x2[i];
            result += Math.exp(this.gamma * factor * factor);
            if (!Tools.isNotEqual(x1[i], 0.0) && !Tools.isNotEqual(x2[i], 0.0)) continue;
            --zeros;
        }
        return Math.pow(result += (double)zeros, this.degree);
    }

    @Override
    public String getDistanceFormula(double[] x, String[] attributeConstructions) {
        StringBuffer result = new StringBuffer();
        result.append("pow((");
        boolean first = true;
        for (int i = 0; i < x.length; ++i) {
            double value = x[i];
            String valueString = "(" + value + " - " + attributeConstructions[i] + ")";
            if (first) {
                result.append("exp(-" + Math.abs(this.gamma) + " * " + valueString + " * " + valueString + ")");
            } else {
                result.append(" + exp(-" + Math.abs(this.gamma) + " * " + valueString + " * " + valueString + ")");
            }
            first = false;
        }
        result.append("), " + this.degree + ")");
        return result.toString();
    }

    public String toString() {
        return "Anova Kernel with" + Tools.getLineSeparator() + "  gamma: " + Tools.formatNumber(this.getGamma()) + Tools.getLineSeparator() + "  degree: " + this.degree;
    }
}

