/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.window;

import com.rapidminer.tools.math.function.window.BartlettWindowFunction;
import com.rapidminer.tools.math.function.window.BlackmanHarrisWindowFunction;
import com.rapidminer.tools.math.function.window.BlackmanWindowFunction;
import com.rapidminer.tools.math.function.window.GaussianWindowFunction;
import com.rapidminer.tools.math.function.window.HammingWindowFunction;
import com.rapidminer.tools.math.function.window.HannWindowFunction;
import com.rapidminer.tools.math.function.window.RectangularWindowFunction;
import com.rapidminer.tools.math.function.window.TriangularWindowFunction;
import java.lang.reflect.InvocationTargetException;

public abstract class WindowFunction {
    public static final Class[] FUNCTIONS = new Class[]{RectangularWindowFunction.class, TriangularWindowFunction.class, GaussianWindowFunction.class, HannWindowFunction.class, HammingWindowFunction.class, BlackmanWindowFunction.class, BlackmanHarrisWindowFunction.class, BartlettWindowFunction.class};
    public static final String[] FUNCTION_NAMES = new String[]{"Rectangular", "Triangular", "Gaussian", "Hann", "Hamming", "Blackman", "Blackman-Harris", "Bartlett"};
    public static final int RECTANGULAR = 0;
    public static final int TRIANGULAR = 1;
    public static final int GAUSSIAN = 2;
    public static final int HANN = 3;
    public static final int HAMMING = 4;
    public static final int BLACKMAN = 5;
    public static final int BLACKMAN_HARRIS = 6;
    public static final int BARTLETT = 7;
    public static final int JUSTIFY_CENTER = 0;
    public static final int JUSTIFY_LEFT = 1;
    public static final int JUSTIFY_RIGHT = 2;
    private int width;
    private int justifiedWidth;
    private int justifiedOffset;

    public static WindowFunction createWindowFunction(String functionName, int justification, int width) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        int typeIndex = -1;
        for (int i = 0; i < FUNCTION_NAMES.length; ++i) {
            if (!FUNCTION_NAMES[i].equals(functionName)) continue;
            typeIndex = i;
            break;
        }
        Class clazz = null;
        clazz = typeIndex < 0 ? Class.forName(functionName) : FUNCTIONS[typeIndex];
        return (WindowFunction)clazz.getConstructor(Integer.class, Integer.class).newInstance(width, justification);
    }

    public static WindowFunction createWindowFunction(String functionName, int width) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        return WindowFunction.createWindowFunction(functionName, 0, width);
    }

    public static WindowFunction createWindowFunction(int typeIndex, int justification, int width) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (typeIndex >= 0 && typeIndex < FUNCTION_NAMES.length) {
            Class clazz = FUNCTIONS[typeIndex];
            return (WindowFunction)clazz.getConstructor(Integer.class, Integer.class).newInstance(width, justification);
        }
        throw new InstantiationException();
    }

    public static WindowFunction createWindowFunction(int typeIndex, int width) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return WindowFunction.createWindowFunction(typeIndex, 0, width);
    }

    public WindowFunction(int width) {
        this(width, 0);
    }

    public WindowFunction(int width, int justification) {
        this.width = width;
        switch (justification) {
            case 0: {
                this.justifiedWidth = width;
                this.justifiedOffset = 0;
                break;
            }
            case 1: {
                this.justifiedWidth = width * 2;
                this.justifiedOffset = width;
                break;
            }
            case 2: {
                this.justifiedWidth = width * 2;
                this.justifiedOffset = 0;
            }
        }
    }

    public double[] getWeights() {
        double[] weights = new double[this.width];
        for (int i = 0; i < this.width; ++i) {
            weights[i] = this.getValue(this.justifiedWidth, this.justifiedOffset + i);
        }
        return weights;
    }

    protected abstract double getValue(int var1, int var2);

    public double getValue(int n) {
        return this.getValue(this.width, n);
    }
}

