/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.expressions.text;

import com.rapidminer.tools.math.function.UnknownValue;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class ParseNumber
extends PostfixMathCommand {
    public ParseNumber() {
        this.numberOfParameters = 1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object value = stack.pop();
        if (value == UnknownValue.UNKNOWN_NOMINAL) {
            stack.push(Double.NaN);
            return;
        }
        if (!(value instanceof String)) {
            throw new ParseException("Invalid argument type, only strings are supported.");
        }
        try {
            stack.push(Double.parseDouble((String)value));
        }
        catch (NumberFormatException e) {
            throw new ParseException("String '" + value + "' is not a number.");
        }
    }
}

