/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.expressions.date;

import com.rapidminer.tools.math.function.UnknownValue;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class DateSet
extends PostfixMathCommand {
    public DateSet() {
        this.numberOfParameters = -1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Locale locale = Locale.getDefault();
        TimeZone zone = TimeZone.getDefault();
        if (this.curNumberOfParameters == 5) {
            Object timezoneObject = stack.pop();
            if (!(timezoneObject instanceof String)) {
                throw new ParseException("Invalid argument type for 'date_set', fifth argument must be (String) for TimeZone (e.g. America/Los_Angeles)");
            }
            zone = TimeZone.getTimeZone(String.valueOf(timezoneObject));
            Object localeObject = stack.pop();
            if (!(localeObject instanceof String)) {
                throw new ParseException("Invalid argument type for 'date_set', fourth argument must be (String) for locale (e.g. \"en\")");
            }
            locale = new Locale(String.valueOf(localeObject));
        } else if (this.curNumberOfParameters != 3) {
            throw new ParseException("Invalid number of arguments for 'date_set', must be either 3 or 5.");
        }
        Object unitConstantObject = stack.pop();
        if (!(unitConstantObject instanceof String)) {
            throw new ParseException("Invalid argument type for 'date_set', third argument must be unit constant (e.g. DATE_UNIT_HOUR)");
        }
        String unitConstant = String.valueOf(unitConstantObject);
        Object setValueObject = stack.pop();
        if (setValueObject instanceof Double && ((Double)setValueObject).isNaN()) {
            stack.push(UnknownValue.UNKNOWN_DATE);
            return;
        }
        if (!(setValueObject instanceof Double)) {
            throw new ParseException("Invalid argument type for 'date_set', second argument must be a number");
        }
        double setValue = (Double)setValueObject;
        Object calObject = stack.pop();
        if (calObject == UnknownValue.UNKNOWN_DATE) {
            stack.push(UnknownValue.UNKNOWN_DATE);
            return;
        }
        if (!(calObject instanceof Calendar)) {
            throw new ParseException("Invalid argument type for 'date_set', first argument must be Calendar");
        }
        Calendar calOld = (Calendar)calObject;
        Date date = calOld.getTime();
        Calendar cal = GregorianCalendar.getInstance(zone, locale);
        cal.setTime(date);
        if (unitConstant.equals("EPConstants_date_unit_year")) {
            cal.set(1, (int)setValue);
        } else if (unitConstant.equals("EPConstants_date_unit_month")) {
            cal.set(2, (int)setValue);
        } else if (unitConstant.equals("EPConstants_date_unit_week")) {
            cal.set(3, (int)setValue);
        } else if (unitConstant.equals("EPConstants_date_unit_day")) {
            cal.set(5, (int)setValue);
        } else if (unitConstant.equals("EPConstants_date_unit_hour")) {
            cal.set(11, (int)setValue);
        } else if (unitConstant.equals("EPConstants_date_unit_minute")) {
            cal.set(12, (int)setValue);
        } else if (unitConstant.equals("EPConstants_date_unit_second")) {
            cal.set(13, (int)setValue);
        } else if (unitConstant.equals("EPConstants_date_unit_millisecond")) {
            cal.set(14, (int)setValue);
        } else {
            throw new ParseException("Invalid argument type for 'date_set', third argument must be unit constant (e.g. DATE_UNIT_HOUR)");
        }
        stack.push(cal);
    }
}

