/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.expressions.date;

import com.rapidminer.tools.math.function.UnknownValue;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class DateParseWithLocale
extends PostfixMathCommand {
    public DateParseWithLocale() {
        this.numberOfParameters = 2;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Locale locale = Locale.getDefault();
        Object localeObject = stack.pop();
        if (!(localeObject instanceof String)) {
            throw new ParseException("Invalid argument type for 'date_parse_loc', second argument must be (String) for locale (e.g. \"en\")");
        }
        locale = new Locale(String.valueOf(localeObject));
        Object dateObject = stack.pop();
        if (dateObject == UnknownValue.UNKNOWN_NOMINAL || dateObject instanceof Double && ((Double)dateObject).isNaN()) {
            stack.push(UnknownValue.UNKNOWN_DATE);
            return;
        }
        if (dateObject instanceof Double) {
            try {
                dateObject = (long)((Double)dateObject).doubleValue();
            }
            catch (ClassCastException e) {
                throw new ParseException("Invalid argument for 'date_parse_loc', cannot convert to Date");
            }
        }
        if (!(dateObject instanceof String) && !(dateObject instanceof Long)) {
            throw new ParseException("Invalid argument type for 'date_parse_loc', first argument must be (string) or (long)");
        }
        if (dateObject instanceof String) {
            String dateString = (String)dateObject;
            try {
                Date date = DateFormat.getDateInstance(3, locale).parse(dateString);
                Calendar cal = GregorianCalendar.getInstance(locale);
                cal.setTime(date);
                stack.push(cal);
            }
            catch (java.text.ParseException e) {
                throw new ParseException("Bad string argument for 'date_parse_loc' (" + e.getMessage() + ") and given locale (" + locale + ")");
            }
        } else if (dateObject instanceof Long) {
            long dateLong = (Long)dateObject;
            Date date = new Date(dateLong);
            Calendar cal = GregorianCalendar.getInstance(locale);
            cal.setTime(date);
            stack.push(cal);
        }
    }
}

