/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.expressions.date;

import com.rapidminer.tools.math.function.UnknownValue;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class DateParseCustom
extends PostfixMathCommand {
    public DateParseCustom() {
        this.numberOfParameters = -1;
    }

    public void run(Stack stack) throws ParseException {
        Date parsedDate;
        SimpleDateFormat simpleDateFormatter;
        this.checkStack(stack);
        Locale locale = Locale.getDefault();
        if (this.curNumberOfParameters == 3) {
            Object localeObject = stack.pop();
            if (!(localeObject instanceof String)) {
                throw new ParseException("Invalid argument type for 'date_parse_custom', third argument must be (String) for locale (e.g. \"en\")");
            }
            locale = new Locale(String.valueOf(localeObject));
        } else if (this.curNumberOfParameters != 2) {
            throw new ParseException("Invalid number of arguments for 'date_parse_custom', must be either 2 or 3.");
        }
        Object customFormatObject = stack.pop();
        if (!(customFormatObject instanceof String)) {
            throw new ParseException("Invalid argument type for 'date_parse_custom', second argument must be custom formatting string");
        }
        String customFormat = String.valueOf(customFormatObject);
        try {
            simpleDateFormatter = new SimpleDateFormat(customFormat, locale);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Invalid argument type for 'date_parse_custom', second argument must be valid custom formatting string");
        }
        Object customDateObject = stack.pop();
        if (customDateObject == UnknownValue.UNKNOWN_NOMINAL) {
            stack.push(UnknownValue.UNKNOWN_DATE);
            return;
        }
        if (!(customDateObject instanceof String)) {
            throw new ParseException("Invalid argument type for 'date_parse_custom', first argument must be date string");
        }
        String customDate = String.valueOf(customDateObject);
        try {
            parsedDate = simpleDateFormatter.parse(customDate);
        }
        catch (java.text.ParseException e) {
            throw new ParseException("Invalid argument type for 'date_parse_custom', first argument must be valid date string");
        }
        Calendar cal = GregorianCalendar.getInstance(locale);
        cal.setTime(parsedDate);
        stack.push(cal);
    }
}

