/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.expressions.date;

import com.rapidminer.tools.math.function.UnknownValue;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class DateParse
extends PostfixMathCommand {
    public DateParse() {
        this.numberOfParameters = 1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object dateObject = stack.pop();
        if (dateObject == UnknownValue.UNKNOWN_NOMINAL || dateObject instanceof Double && ((Double)dateObject).isNaN()) {
            stack.push(UnknownValue.UNKNOWN_DATE);
            return;
        }
        if (dateObject instanceof Double) {
            dateObject = ((Double)dateObject).longValue();
        }
        if (!(dateObject instanceof String) && !(dateObject instanceof Long)) {
            throw new ParseException("Invalid argument type for 'date_parse', argument must be (string), (double) or (long)");
        }
        if (dateObject instanceof String) {
            String dateString = (String)dateObject;
            try {
                Date date = DateFormat.getDateInstance(3).parse(dateString);
                Calendar cal = GregorianCalendar.getInstance();
                cal.setTime(date);
                stack.push(cal);
            }
            catch (java.text.ParseException e) {
                throw new ParseException("Bad string argument for 'date_parse' (" + e.getMessage() + ")");
            }
        } else if (dateObject instanceof Long) {
            long dateLong = (Long)dateObject;
            Date date = new Date(dateLong);
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime(date);
            stack.push(cal);
        }
    }
}

