/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.expressions.date;

import com.rapidminer.tools.math.function.UnknownValue;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class DateGet
extends PostfixMathCommand {
    public DateGet() {
        this.numberOfParameters = 2;
    }

    public void run(Stack stack) throws ParseException {
        double result;
        this.checkStack(stack);
        Locale locale = Locale.getDefault();
        TimeZone zone = TimeZone.getDefault();
        if (this.curNumberOfParameters == 5) {
            Object timezoneObject = stack.pop();
            if (!(timezoneObject instanceof String)) {
                throw new ParseException("Invalid argument type for 'date_get', fourth argument must be (String) for TimeZone (e.g. America/Los_Angeles)");
            }
            zone = TimeZone.getTimeZone(String.valueOf(timezoneObject));
            Object localeObject = stack.pop();
            if (!(localeObject instanceof String)) {
                throw new ParseException("Invalid argument type for 'date_get', third argument must be (String) for locale (e.g. \"en\")");
            }
            locale = new Locale(String.valueOf(localeObject));
        } else if (this.curNumberOfParameters != 3) {
            throw new ParseException("Invalid number of arguments for 'date_get', must be 2 or 4.");
        }
        Object unitConstantObject = stack.pop();
        if (!(unitConstantObject instanceof String)) {
            throw new ParseException("Invalid argument type for 'date_get', second argument must be unit constant (e.g. DATE_UNIT_HOUR)");
        }
        String unitConstant = String.valueOf(unitConstantObject);
        Object calObject = stack.pop();
        if (calObject == UnknownValue.UNKNOWN_DATE) {
            stack.push(Double.NaN);
            return;
        }
        if (!(calObject instanceof Calendar)) {
            throw new ParseException("Invalid argument type for 'date_get', first argument must be Calendar");
        }
        Calendar calOld = (Calendar)calObject;
        Date date = calOld.getTime();
        Calendar cal = GregorianCalendar.getInstance(zone, locale);
        cal.setTime(date);
        if (unitConstant.equals("EPConstants_date_unit_year")) {
            result = cal.get(1);
        } else if (unitConstant.equals("EPConstants_date_unit_month")) {
            result = cal.get(2);
        } else if (unitConstant.equals("EPConstants_date_unit_week")) {
            result = cal.get(4);
        } else if (unitConstant.equals("EPConstants_date_unit_day")) {
            result = cal.get(5);
        } else if (unitConstant.equals("EPConstants_date_unit_hour")) {
            result = cal.get(11);
        } else if (unitConstant.equals("EPConstants_date_unit_minute")) {
            result = cal.get(12);
        } else if (unitConstant.equals("EPConstants_date_unit_second")) {
            result = cal.get(13);
        } else if (unitConstant.equals("EPConstants_date_unit_millisecond")) {
            result = cal.get(14);
        } else {
            throw new ParseException("Invalid argument type for 'date_get', second argument must be unit constant (e.g. DATE_UNIT_HOUR)");
        }
        stack.push(result);
    }
}

