/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.expressions.date;

import com.rapidminer.tools.math.function.UnknownValue;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class DateDiff
extends PostfixMathCommand {
    public DateDiff() {
        this.numberOfParameters = -1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Locale locale = Locale.getDefault();
        TimeZone zone = TimeZone.getDefault();
        if (this.curNumberOfParameters == 4) {
            Object timezoneObject = stack.pop();
            if (!(timezoneObject instanceof String)) {
                throw new ParseException("Invalid argument type for 'date_diff', fourth argument must be (String) for TimeZone (e.g. America/Los_Angeles)");
            }
            zone = TimeZone.getTimeZone(String.valueOf(timezoneObject));
            Object localeObject = stack.pop();
            if (!(localeObject instanceof String)) {
                throw new ParseException("Invalid argument type for 'date_diff', third argument must be (String) for locale (e.g. \"en\")");
            }
            locale = new Locale(String.valueOf(localeObject));
        } else if (this.curNumberOfParameters != 2) {
            throw new ParseException("Invalid number of arguments for 'date_diff', must be either 2 or 4.");
        }
        Object calObjectTwo = stack.pop();
        Object calObjectOne = stack.pop();
        if (calObjectTwo == UnknownValue.UNKNOWN_DATE || calObjectOne == UnknownValue.UNKNOWN_DATE) {
            stack.push(Double.NaN);
            return;
        }
        if (!(calObjectOne instanceof Calendar) || !(calObjectTwo instanceof Calendar)) {
            throw new ParseException("Invalid argument type for 'date_diff', first and second argument must both be Calendar");
        }
        Calendar calOldOne = (Calendar)calObjectOne;
        Calendar calOldTwo = (Calendar)calObjectTwo;
        Date dateOne = calOldOne.getTime();
        Date dateTwo = calOldTwo.getTime();
        Calendar calOne = GregorianCalendar.getInstance(zone, locale);
        calOne.setTime(dateOne);
        Calendar calTwo = GregorianCalendar.getInstance(zone, locale);
        calTwo.setTime(dateTwo);
        long timeTwo = calTwo.getTimeInMillis() + (long)calTwo.getTimeZone().getOffset(calTwo.getTimeInMillis());
        long timeOne = calOne.getTimeInMillis() + (long)calOne.getTimeZone().getOffset(calOne.getTimeInMillis());
        stack.push(timeTwo - timeOne);
    }
}

