/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.expressions.date;

import com.rapidminer.tools.math.function.UnknownValue;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class DateAdd
extends PostfixMathCommand {
    public DateAdd() {
        this.numberOfParameters = -1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Locale locale = Locale.getDefault();
        TimeZone zone = TimeZone.getDefault();
        if (this.curNumberOfParameters == 5) {
            Object timezoneObject = stack.pop();
            if (!(timezoneObject instanceof String)) {
                throw new ParseException("Invalid argument type for 'date_add', fifth argument must be (String) for TimeZone (e.g. America/Los_Angeles)");
            }
            zone = TimeZone.getTimeZone(String.valueOf(timezoneObject));
            Object localeObject = stack.pop();
            if (!(localeObject instanceof String)) {
                throw new ParseException("Invalid argument type for 'date_add', fourth argument must be (String) for locale (e.g. \"en\")");
            }
            locale = new Locale(String.valueOf(localeObject));
        } else if (this.curNumberOfParameters != 3) {
            throw new ParseException("Invalid number of arguments for 'date_add', must be either 3 or 5.");
        }
        Object unitConstantObject = stack.pop();
        if (!(unitConstantObject instanceof String)) {
            throw new ParseException("Invalid argument type for 'date_add', third argument must be unit constant (e.g. DATE_UNIT_HOUR)");
        }
        String unitConstant = String.valueOf(unitConstantObject);
        Object addedValueObject = stack.pop();
        if (!(addedValueObject instanceof Double)) {
            throw new ParseException("Invalid argument type for 'date_add', second argument must be a number");
        }
        double addedValue = (Double)addedValueObject;
        Object dateObject = stack.pop();
        if (dateObject == UnknownValue.UNKNOWN_DATE) {
            stack.push(UnknownValue.UNKNOWN_NOMINAL);
            return;
        }
        if (!(dateObject instanceof Calendar)) {
            throw new ParseException("Invalid argument type for 'date_add', first argument must be Calendar");
        }
        Calendar dateCal = (Calendar)dateObject;
        Calendar cal = GregorianCalendar.getInstance(zone, locale);
        cal.setTime(dateCal.getTime());
        if (unitConstant.equals("EPConstants_date_unit_year")) {
            cal.add(1, (int)addedValue);
        } else if (unitConstant.equals("EPConstants_date_unit_month")) {
            cal.add(2, (int)addedValue);
        } else if (unitConstant.equals("EPConstants_date_unit_week")) {
            cal.add(3, (int)addedValue);
        } else if (unitConstant.equals("EPConstants_date_unit_day")) {
            cal.add(5, (int)addedValue);
        } else if (unitConstant.equals("EPConstants_date_unit_hour")) {
            cal.add(11, (int)addedValue);
        } else if (unitConstant.equals("EPConstants_date_unit_minute")) {
            cal.add(12, (int)addedValue);
        } else if (unitConstant.equals("EPConstants_date_unit_second")) {
            cal.add(13, (int)addedValue);
        } else if (unitConstant.equals("EPConstants_date_unit_millisecond")) {
            cal.add(14, (int)addedValue);
        } else {
            throw new ParseException("Invalid argument type for 'date_add', third argument must be unit constant (e.g. DATE_UNIT_HOUR)");
        }
        stack.push(cal);
    }
}

