/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.expressions.date;

import com.rapidminer.tools.math.function.UnknownValue;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class Date2StringWithLocale
extends PostfixMathCommand {
    public Date2StringWithLocale() {
        this.numberOfParameters = 4;
    }

    public void run(Stack stack) throws ParseException {
        DateFormat dateFormat;
        int formatting;
        this.checkStack(stack);
        Locale locale = Locale.getDefault();
        Object localeObject = stack.pop();
        if (!(localeObject instanceof String)) {
            throw new ParseException("Invalid argument type for 'date_str_loc', fourth argument must be (String) for locale (e.g. \"en\")");
        }
        locale = new Locale(String.valueOf(localeObject));
        Object constantShowObject = stack.pop();
        if (!(constantShowObject instanceof String)) {
            throw new ParseException("Invalid argument type for 'date_str_loc', third argument must be show constant (e.g. DATE_SHOW_DATE_ONLY)");
        }
        String constantShow = (String)constantShowObject;
        Object constantFormatObject = stack.pop();
        if (!(constantFormatObject instanceof String)) {
            throw new ParseException("Invalid argument type for 'date_str_loc', second argument must be formatting constant (e.g. DATE_FULL)");
        }
        String constantFormat = (String)constantFormatObject;
        Object dateObject = stack.pop();
        if (dateObject == UnknownValue.UNKNOWN_DATE) {
            stack.push(UnknownValue.UNKNOWN_NOMINAL);
            return;
        }
        if (!(dateObject instanceof Calendar)) {
            throw new ParseException("Invalid argument type for 'date_str_loc', first argument must be Calendar");
        }
        Calendar dateCal = (Calendar)dateObject;
        if (constantFormat.equals("EPConstants_date_rep_full")) {
            formatting = 0;
        } else if (constantFormat.equals("EPConstants_date_rep_long")) {
            formatting = 1;
        } else if (constantFormat.equals("EPConstants_date_rep_medium")) {
            formatting = 2;
        } else if (constantFormat.equals("EPConstants_date_rep_short")) {
            formatting = 3;
        } else {
            throw new ParseException("Invalid format constant for 'date_str_loc'");
        }
        if (constantShow.equals("EPConstants_show_date_date_only")) {
            dateFormat = DateFormat.getDateInstance(formatting, locale);
        } else if (constantShow.equals("EPConstants_show_date_time_only")) {
            dateFormat = DateFormat.getTimeInstance(formatting, locale);
        } else if (constantShow.equals("EPConstants_show_date_and_time")) {
            dateFormat = DateFormat.getDateTimeInstance(formatting, formatting, locale);
        } else {
            throw new ParseException("Invalid show constant for 'date_str_loc'");
        }
        String result = dateFormat.format(dateCal.getTime());
        stack.push(result);
    }
}

