/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.expressions.date;

import com.rapidminer.tools.math.function.UnknownValue;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class Date2StringCustom
extends PostfixMathCommand {
    public Date2StringCustom() {
        this.numberOfParameters = -1;
    }

    public void run(Stack stack) throws ParseException {
        SimpleDateFormat simpleDateFormatter;
        this.checkStack(stack);
        Locale locale = Locale.getDefault();
        if (this.curNumberOfParameters == 3) {
            Object localeObject = stack.pop();
            if (!(localeObject instanceof String)) {
                throw new ParseException("Invalid argument type for 'date_str_custom', third argument must be (String) for locale (e.g. \"en\")");
            }
            locale = new Locale(String.valueOf(localeObject));
        } else if (this.curNumberOfParameters != 2) {
            throw new ParseException("Invalid number of arguments for 'date_str_custom', must be either 2 or 3.");
        }
        Object customFormatObject = stack.pop();
        if (!(customFormatObject instanceof String)) {
            throw new ParseException("Invalid argument type for 'date_str_custom', second argument must be custom formatting string");
        }
        String customFormat = String.valueOf(customFormatObject);
        try {
            simpleDateFormatter = new SimpleDateFormat(customFormat, locale);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Invalid argument for 'date_str_custom', second argument must be valid custom formatting string");
        }
        Object customCalObject = stack.pop();
        if (customCalObject == UnknownValue.UNKNOWN_DATE) {
            stack.push(UnknownValue.UNKNOWN_NOMINAL);
            return;
        }
        if (!(customCalObject instanceof Calendar)) {
            throw new ParseException("Invalid argument type for 'date_str_custom', first argument must be Calendar");
        }
        Calendar cal = (Calendar)customCalObject;
        String result = simpleDateFormatter.format(cal.getTime());
        stack.push(result);
    }
}

