/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.expressions;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.Add;
import org.nfunk.jep.function.Divide;
import org.nfunk.jep.function.PostfixMathCommand;

public class Average
extends PostfixMathCommand {
    private Add addFun = new Add();
    private Divide divideFun = new Divide();

    public Average() {
        this.numberOfParameters = -1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object sum = stack.pop();
        if (!(sum instanceof Double)) {
            throw new ParseException("Invalid parameter type, only numbers are allowed for 'min'.");
        }
        for (int i = 1; i < this.curNumberOfParameters; ++i) {
            Object param = stack.pop();
            if (!(param instanceof Double)) {
                throw new ParseException("Invalid parameter type, only numbers are allowed for 'avg'.");
            }
            sum = this.addFun.add(param, sum);
        }
        sum = this.divideFun.div(sum, (Object)this.curNumberOfParameters);
        stack.push(sum);
    }
}

