/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.aggregation;

import com.rapidminer.example.Attribute;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;

public class VarianceFunction
extends AbstractAggregationFunction {
    private double valueSum;
    private double squaredValueSum;
    private double totalWeightSum;
    private double count;

    public VarianceFunction() {
        this(true);
    }

    public VarianceFunction(Boolean ignoreMissings) {
        super(ignoreMissings);
    }

    @Override
    public String getName() {
        return "variance";
    }

    @Override
    protected void reset() {
        this.foundMissing = false;
        this.valueSum = 0.0;
        this.squaredValueSum = 0.0;
        this.totalWeightSum = 0.0;
        this.count = 0.0;
    }

    @Override
    public void update(double value, double weight) {
        if (Double.isNaN(value)) {
            this.foundMissing = true;
            return;
        }
        this.valueSum += weight * value;
        this.squaredValueSum += weight * value * value;
        this.totalWeightSum += weight;
        this.count += 1.0;
    }

    @Override
    public void update(double value) {
        if (Double.isNaN(value)) {
            this.foundMissing = true;
            return;
        }
        this.valueSum += value;
        this.squaredValueSum += value * value;
        this.totalWeightSum += 1.0;
        this.count += 1.0;
    }

    @Override
    public double getValue() {
        if (this.foundMissing && !this.ignoreMissings) {
            return Double.NaN;
        }
        if (this.count <= 1.0 || this.totalWeightSum <= 0.0) {
            return 0.0;
        }
        return (this.squaredValueSum - this.valueSum * this.valueSum / this.totalWeightSum) / ((this.count - 1.0) / this.count * this.totalWeightSum);
    }

    @Override
    public boolean supportsAttribute(Attribute attribute) {
        return attribute.isNumerical();
    }
}

