/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.aggregation;

import com.rapidminer.example.Attribute;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;

public class SumFunction
extends AbstractAggregationFunction {
    private double valueSum;

    public SumFunction() {
        this(true);
    }

    public SumFunction(Boolean ignoreMissings) {
        super(ignoreMissings);
    }

    @Override
    public String getName() {
        return "sum";
    }

    @Override
    protected void reset() {
        this.foundMissing = false;
        this.valueSum = 0.0;
    }

    @Override
    public void update(double value, double weight) {
        if (Double.isNaN(value)) {
            this.foundMissing = true;
            return;
        }
        this.valueSum += value * weight;
    }

    @Override
    public void update(double value) {
        if (Double.isNaN(value)) {
            this.foundMissing = true;
            return;
        }
        this.valueSum += value;
    }

    @Override
    public double getValue() {
        if (this.foundMissing && !this.ignoreMissings) {
            return Double.NaN;
        }
        return this.valueSum;
    }

    @Override
    public boolean supportsAttribute(Attribute attribute) {
        return attribute.isNumerical();
    }
}

