/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.aggregation;

import com.rapidminer.example.Attribute;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;

public class ProductFunction
extends AbstractAggregationFunction {
    private double product = 1.0;

    public ProductFunction() {
    }

    public ProductFunction(Boolean ignoreMissings) {
        super(ignoreMissings);
    }

    @Override
    protected void reset() {
        this.product = 1.0;
    }

    @Override
    public String getName() {
        return "product";
    }

    @Override
    public double getValue() {
        return this.product;
    }

    @Override
    public boolean supportsAttribute(Attribute attribute) {
        return attribute.isNumerical();
    }

    @Override
    public void update(double value, double weight) {
        if (!Double.isNaN(value) && !Double.isNaN(weight)) {
            this.product *= value * weight;
        }
    }

    @Override
    public void update(double value) {
        if (!Double.isNaN(value)) {
            this.product *= value;
        }
    }
}

