/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.aggregation;

import com.rapidminer.example.Attribute;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;

public class MinFunction
extends AbstractAggregationFunction {
    private double minValue;

    public MinFunction() {
        this(true);
    }

    public MinFunction(Boolean ignoreMissings) {
        super(ignoreMissings);
    }

    @Override
    public String getName() {
        return "minimum";
    }

    @Override
    protected void reset() {
        this.foundMissing = false;
        this.minValue = Double.POSITIVE_INFINITY;
    }

    @Override
    public void update(double value, double weight) {
        this.update(value);
    }

    @Override
    public void update(double value) {
        if (Double.isNaN(value)) {
            this.foundMissing = true;
            return;
        }
        if (value < this.minValue) {
            this.minValue = value;
        }
    }

    @Override
    public double getValue() {
        if (this.foundMissing && !this.ignoreMissings) {
            return Double.NaN;
        }
        return this.minValue;
    }

    @Override
    public boolean supportsAttribute(Attribute attribute) {
        return attribute.isNumerical() || Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9);
    }
}

