/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.aggregation;

import com.rapidminer.example.Attribute;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;

public class CountFunction
extends AbstractAggregationFunction {
    double totalWeightSum;

    public CountFunction() {
        this(true);
    }

    public CountFunction(Boolean ignoreMissings) {
        super(ignoreMissings);
    }

    @Override
    public String getName() {
        return "count";
    }

    @Override
    protected void reset() {
        this.foundMissing = false;
        this.totalWeightSum = 0.0;
    }

    @Override
    public void update(double value, double weight) {
        if (Double.isNaN(value)) {
            this.foundMissing = true;
            return;
        }
        this.totalWeightSum += weight;
    }

    @Override
    public void update(double value) {
        if (Double.isNaN(value)) {
            this.foundMissing = true;
            return;
        }
        this.totalWeightSum += 1.0;
    }

    @Override
    public double getValue() {
        if (this.foundMissing && !this.ignoreMissings) {
            return Double.NaN;
        }
        return this.totalWeightSum;
    }

    @Override
    public boolean supportsAttribute(Attribute attribute) {
        return true;
    }

    @Override
    public boolean supportsAttribute(AttributeMetaData amd) {
        return true;
    }
}

