/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.aggregation;

import com.rapidminer.example.Attribute;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;

public class AverageFunction
extends AbstractAggregationFunction {
    private double valueSum;
    private double totalWeightSum;

    public AverageFunction() {
        this(true);
    }

    public AverageFunction(Boolean ignoreMissings) {
        super(ignoreMissings);
    }

    @Override
    public String getName() {
        return "average";
    }

    @Override
    protected void reset() {
        this.foundMissing = false;
        this.valueSum = 0.0;
        this.totalWeightSum = 0.0;
    }

    @Override
    public void update(double value, double weight) {
        if (Double.isNaN(value)) {
            this.foundMissing = true;
            return;
        }
        this.valueSum += value * weight;
        this.totalWeightSum += weight;
    }

    @Override
    public void update(double value) {
        if (Double.isNaN(value)) {
            this.foundMissing = true;
            return;
        }
        this.valueSum += value;
        this.totalWeightSum += 1.0;
    }

    @Override
    public double getValue() {
        if (this.foundMissing && !this.ignoreMissings) {
            return Double.NaN;
        }
        return this.valueSum / this.totalWeightSum;
    }

    @Override
    public boolean supportsAttribute(Attribute attribute) {
        return attribute.isNumerical();
    }
}

