/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function;

import com.rapidminer.MacroHandler;
import com.rapidminer.Process;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.generator.GenerationException;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.function.FunctionDescription;
import com.rapidminer.tools.math.function.UnknownValue;
import com.rapidminer.tools.math.function.expressions.Average;
import com.rapidminer.tools.math.function.expressions.Constant;
import com.rapidminer.tools.math.function.expressions.LogarithmDualis;
import com.rapidminer.tools.math.function.expressions.Maximum;
import com.rapidminer.tools.math.function.expressions.Minimum;
import com.rapidminer.tools.math.function.expressions.Missing;
import com.rapidminer.tools.math.function.expressions.ParameterValue;
import com.rapidminer.tools.math.function.expressions.Signum;
import com.rapidminer.tools.math.function.expressions.date.Date2String;
import com.rapidminer.tools.math.function.expressions.date.Date2StringCustom;
import com.rapidminer.tools.math.function.expressions.date.Date2StringWithLocale;
import com.rapidminer.tools.math.function.expressions.date.DateAdd;
import com.rapidminer.tools.math.function.expressions.date.DateAfter;
import com.rapidminer.tools.math.function.expressions.date.DateBefore;
import com.rapidminer.tools.math.function.expressions.date.DateCreate;
import com.rapidminer.tools.math.function.expressions.date.DateDiff;
import com.rapidminer.tools.math.function.expressions.date.DateGet;
import com.rapidminer.tools.math.function.expressions.date.DateParse;
import com.rapidminer.tools.math.function.expressions.date.DateParseCustom;
import com.rapidminer.tools.math.function.expressions.date.DateParseWithLocale;
import com.rapidminer.tools.math.function.expressions.date.DateSet;
import com.rapidminer.tools.math.function.expressions.number.Str;
import com.rapidminer.tools.math.function.expressions.text.CharAt;
import com.rapidminer.tools.math.function.expressions.text.Compare;
import com.rapidminer.tools.math.function.expressions.text.Concat;
import com.rapidminer.tools.math.function.expressions.text.Contains;
import com.rapidminer.tools.math.function.expressions.text.EndsWith;
import com.rapidminer.tools.math.function.expressions.text.Equals;
import com.rapidminer.tools.math.function.expressions.text.EscapeHTML;
import com.rapidminer.tools.math.function.expressions.text.Finds;
import com.rapidminer.tools.math.function.expressions.text.IndexOf;
import com.rapidminer.tools.math.function.expressions.text.Length;
import com.rapidminer.tools.math.function.expressions.text.LowerCase;
import com.rapidminer.tools.math.function.expressions.text.Matches;
import com.rapidminer.tools.math.function.expressions.text.ParseNumber;
import com.rapidminer.tools.math.function.expressions.text.Prefix;
import com.rapidminer.tools.math.function.expressions.text.Replace;
import com.rapidminer.tools.math.function.expressions.text.ReplaceRegex;
import com.rapidminer.tools.math.function.expressions.text.StartsWith;
import com.rapidminer.tools.math.function.expressions.text.Substring;
import com.rapidminer.tools.math.function.expressions.text.Suffix;
import com.rapidminer.tools.math.function.expressions.text.Trim;
import com.rapidminer.tools.math.function.expressions.text.UpperCase;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.nfunk.jep.JEP;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.type.Complex;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ExpressionParser {
    private static final String[] FUNCTION_GROUPS = new String[]{"Basic Operators", "Log and Exponential", "Trigonometric", "Statistical", "Text", "Date", "Process", "Miscellaneous"};
    private static final Map<String, List<FunctionDescription>> FUNCTIONS = new HashMap<String, List<FunctionDescription>>();
    private JEP parser;

    public ExpressionParser(boolean useStandardConstants) {
        this.initParser(useStandardConstants);
    }

    public ExpressionParser(boolean useStandardConstants, Process process) {
        this(useStandardConstants);
        if (process != null) {
            this.parser.addFunction("param", (PostfixMathCommandI)new ParameterValue(process));
        }
    }

    private void addCustomFunctions(JEP parser) {
        parser.addFunction("const", (PostfixMathCommandI)new Constant());
        parser.addFunction("str", (PostfixMathCommandI)new Str());
        parser.addFunction("avg", (PostfixMathCommandI)new Average());
        parser.addFunction("min", (PostfixMathCommandI)new Minimum());
        parser.addFunction("max", (PostfixMathCommandI)new Maximum());
        parser.addFunction("ld", (PostfixMathCommandI)new LogarithmDualis());
        parser.addFunction("sgn", (PostfixMathCommandI)new Signum());
        parser.addFunction("missing", (PostfixMathCommandI)new Missing());
        parser.addFunction("parse", (PostfixMathCommandI)new ParseNumber());
        parser.addFunction("cut", (PostfixMathCommandI)new Substring());
        parser.addFunction("concat", (PostfixMathCommandI)new Concat());
        parser.addFunction("replace", (PostfixMathCommandI)new Replace());
        parser.addFunction("replaceAll", (PostfixMathCommandI)new ReplaceRegex());
        parser.addFunction("lower", (PostfixMathCommandI)new LowerCase());
        parser.addFunction("upper", (PostfixMathCommandI)new UpperCase());
        parser.addFunction("index", (PostfixMathCommandI)new IndexOf());
        parser.addFunction("length", (PostfixMathCommandI)new Length());
        parser.addFunction("char", (PostfixMathCommandI)new CharAt());
        parser.addFunction("compare", (PostfixMathCommandI)new Compare());
        parser.addFunction("equals", (PostfixMathCommandI)new Equals());
        parser.addFunction("contains", (PostfixMathCommandI)new Contains());
        parser.addFunction("starts", (PostfixMathCommandI)new StartsWith());
        parser.addFunction("ends", (PostfixMathCommandI)new EndsWith());
        parser.addFunction("matches", (PostfixMathCommandI)new Matches());
        parser.addFunction("finds", (PostfixMathCommandI)new Finds());
        parser.addFunction("prefix", (PostfixMathCommandI)new Prefix());
        parser.addFunction("suffix", (PostfixMathCommandI)new Suffix());
        parser.addFunction("trim", (PostfixMathCommandI)new Trim());
        parser.addFunction("escape_html", (PostfixMathCommandI)new EscapeHTML());
        parser.addFunction("date_parse", (PostfixMathCommandI)new DateParse());
        parser.addFunction("date_parse_loc", (PostfixMathCommandI)new DateParseWithLocale());
        parser.addFunction("date_parse_custom", (PostfixMathCommandI)new DateParseCustom());
        parser.addFunction("date_before", (PostfixMathCommandI)new DateBefore());
        parser.addFunction("date_after", (PostfixMathCommandI)new DateAfter());
        parser.addFunction("date_str", (PostfixMathCommandI)new Date2String());
        parser.addFunction("date_str_loc", (PostfixMathCommandI)new Date2StringWithLocale());
        parser.addFunction("date_str_custom", (PostfixMathCommandI)new Date2StringCustom());
        parser.addFunction("date_now", (PostfixMathCommandI)new DateCreate());
        parser.addFunction("date_diff", (PostfixMathCommandI)new DateDiff());
        parser.addFunction("date_add", (PostfixMathCommandI)new DateAdd());
        parser.addFunction("date_set", (PostfixMathCommandI)new DateSet());
        parser.addFunction("date_get", (PostfixMathCommandI)new DateGet());
    }

    private void addCustomConstants(JEP parser) {
        parser.addConstant("DATE_SHORT", (Object)"EPConstants_date_rep_short");
        parser.addConstant("DATE_MEDIUM", (Object)"EPConstants_date_rep_medium");
        parser.addConstant("DATE_LONG", (Object)"EPConstants_date_rep_long");
        parser.addConstant("DATE_FULL", (Object)"EPConstants_date_rep_full");
        parser.addConstant("DATE_SHOW_DATE_ONLY", (Object)"EPConstants_show_date_date_only");
        parser.addConstant("DATE_SHOW_TIME_ONLY", (Object)"EPConstants_show_date_time_only");
        parser.addConstant("DATE_SHOW_DATE_AND_TIME", (Object)"EPConstants_show_date_and_time");
        parser.addConstant("DATE_UNIT_YEAR", (Object)"EPConstants_date_unit_year");
        parser.addConstant("DATE_UNIT_MONTH", (Object)"EPConstants_date_unit_month");
        parser.addConstant("DATE_UNIT_WEEK", (Object)"EPConstants_date_unit_week");
        parser.addConstant("DATE_UNIT_DAY", (Object)"EPConstants_date_unit_day");
        parser.addConstant("DATE_UNIT_HOUR", (Object)"EPConstants_date_unit_hour");
        parser.addConstant("DATE_UNIT_MINUTE", (Object)"EPConstants_date_unit_minute");
        parser.addConstant("DATE_UNIT_SECOND", (Object)"EPConstants_date_unit_second");
        parser.addConstant("DATE_UNIT_MILLISECOND", (Object)"EPConstants_date_unit_millisecond");
    }

    public String[] getFunctionGroups() {
        return FUNCTION_GROUPS;
    }

    public List<FunctionDescription> getFunctions(String functionGroup) {
        return FUNCTIONS.get(functionGroup);
    }

    public void initParser(boolean useStandardConstants) {
        this.parser = new JEP();
        this.parser.addStandardFunctions();
        if (useStandardConstants) {
            this.parser.addStandardConstants();
        }
        this.addCustomFunctions(this.parser);
        this.addCustomConstants(this.parser);
        this.parser.setAllowUndeclared(false);
        this.parser.setImplicitMul(false);
    }

    public void addMacro(MacroHandler macroHandler, String name, String function) throws GenerationException {
        this.parser.parseExpression(function);
        if (this.parser.hasError()) {
            throw new GenerationException(this.parser.getErrorInfo());
        }
        Object result = this.parser.getValueAsObject();
        if (this.parser.hasError()) {
            throw new GenerationException(this.parser.getErrorInfo());
        }
        if (result != null) {
            try {
                macroHandler.addMacro(name, Tools.formatIntegerIfPossible(Double.parseDouble(result.toString())));
            }
            catch (NumberFormatException e) {
                macroHandler.addMacro(name, result.toString());
            }
        }
    }

    public void addAttributeMetaData(ExampleSetMetaData emd, String name, String function) {
        this.parser.setAllowUndeclared(true);
        this.parser.parseExpression(function);
        if (!this.parser.hasError()) {
            SymbolTable symbolTable = this.parser.getSymbolTable();
            HashMap<String, AttributeMetaData> name2attributes = new HashMap<String, AttributeMetaData>();
            for (Object variableObj : symbolTable.values()) {
                AttributeMetaData attribute;
                Variable variable = (Variable)variableObj;
                if (variable.isConstant() || (attribute = emd.getAttributeByName(variable.getName())) == null) continue;
                name2attributes.put(variable.getName(), attribute);
                if (attribute.isNominal()) {
                    this.parser.addVariable(attribute.getName(), (Object)"");
                    continue;
                }
                this.parser.addVariable(attribute.getName(), Double.NaN);
            }
            if (!this.parser.hasError()) {
                Object result = this.parser.getValueAsObject();
                if (!this.parser.hasError()) {
                    AttributeMetaData newAttribute = null;
                    if (result instanceof Boolean) {
                        newAttribute = new AttributeMetaData(name, 6);
                        HashSet<String> values = new HashSet<String>();
                        values.add("false");
                        values.add("true");
                        newAttribute.setValueSet(values, SetRelation.EQUAL);
                    } else {
                        newAttribute = result instanceof Number ? new AttributeMetaData(name, 4) : (result instanceof Complex ? new AttributeMetaData(name, 4) : (result instanceof Date ? new AttributeMetaData(name, 9) : (result instanceof Calendar ? new AttributeMetaData(name, 9) : new AttributeMetaData(name, 1))));
                    }
                    emd.addAttribute(newAttribute);
                } else {
                    emd.addAttribute(new AttributeMetaData(name, 0));
                }
            } else {
                emd.addAttribute(new AttributeMetaData(name, 0));
            }
        } else {
            emd.addAttribute(new AttributeMetaData(name, 0));
        }
    }

    public Attribute addAttribute(ExampleSet exampleSet, String name, String function) throws GenerationException {
        this.parser.setAllowUndeclared(true);
        this.parser.parseExpression(function);
        if (this.parser.hasError()) {
            throw new GenerationException(function + ": " + this.parser.getErrorInfo());
        }
        SymbolTable symbolTable = this.parser.getSymbolTable();
        HashMap<String, Attribute> name2attributes = new HashMap<String, Attribute>();
        for (Object variableObj : symbolTable.values()) {
            Variable variable = (Variable)variableObj;
            if (variable.isConstant()) continue;
            Attribute attribute = exampleSet.getAttributes().get(variable.getName());
            if (attribute == null) {
                throw new GenerationException("No such attribute: '" + variable.getName() + "'");
            }
            name2attributes.put(variable.getName(), attribute);
            if (exampleSet.size() > 0) {
                Example example = (Example)exampleSet.iterator().next();
                if (attribute.isNominal()) {
                    if (Double.isNaN(example.getValue(attribute))) {
                        this.parser.addVariable(attribute.getName(), Double.NaN);
                        continue;
                    }
                    this.parser.addVariable(attribute.getName(), (Object)example.getValueAsString(attribute));
                    continue;
                }
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9)) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(new Date((long)example.getValue(attribute)));
                    this.parser.addVariable(attribute.getName(), (Object)cal);
                    continue;
                }
                this.parser.addVariable(attribute.getName(), example.getValue(attribute));
                continue;
            }
            if (attribute.isNominal()) {
                this.parser.addVariable(attribute.getName(), (Object)"");
                continue;
            }
            this.parser.addVariable(attribute.getName(), Double.NaN);
        }
        if (this.parser.hasError()) {
            throw new GenerationException(this.parser.getErrorInfo());
        }
        Object result = this.parser.getValueAsObject();
        if (this.parser.hasError()) {
            throw new GenerationException(this.parser.getErrorInfo());
        }
        Attribute newAttribute = null;
        if (result instanceof Boolean || result == UnknownValue.UNKNOWN_BOOLEAN) {
            newAttribute = AttributeFactory.createAttribute(name, 6);
            newAttribute.getMapping().mapString("false");
            newAttribute.getMapping().mapString("true");
        } else {
            newAttribute = result instanceof Number ? AttributeFactory.createAttribute(name, 4) : (result instanceof Complex ? AttributeFactory.createAttribute(name, 4) : (result instanceof Date || result == UnknownValue.UNKNOWN_DATE ? AttributeFactory.createAttribute(name, 9) : (result instanceof Calendar || result == UnknownValue.UNKNOWN_DATE ? AttributeFactory.createAttribute(name, 9) : AttributeFactory.createAttribute(name, 1))));
        }
        newAttribute.setConstruction(function);
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        for (Example example : exampleSet) {
            for (Map.Entry entry : name2attributes.entrySet()) {
                String variableName = (String)entry.getKey();
                Attribute attribute = (Attribute)entry.getValue();
                double value = example.getValue(attribute);
                if (attribute.isNominal()) {
                    if (Double.isNaN(value)) {
                        this.parser.setVarValue(variableName, (Object)UnknownValue.UNKNOWN_NOMINAL);
                        continue;
                    }
                    this.parser.setVarValue(variableName, (Object)example.getValueAsString(attribute));
                    continue;
                }
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9)) {
                    if (Double.isNaN(value)) {
                        this.parser.setVarValue(variableName, (Object)UnknownValue.UNKNOWN_DATE);
                        continue;
                    }
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(new Date((long)value));
                    this.parser.setVarValue(variableName, (Object)cal);
                    continue;
                }
                this.parser.setVarValue(variableName, (Object)value);
            }
            result = this.parser.getValueAsObject();
            if (this.parser.hasError()) {
                throw new GenerationException(this.parser.getErrorInfo());
            }
            if (result instanceof Boolean) {
                if (((Boolean)result).booleanValue()) {
                    example.setValue(newAttribute, newAttribute.getMapping().mapString("true"));
                    continue;
                }
                example.setValue(newAttribute, newAttribute.getMapping().mapString("false"));
                continue;
            }
            if (result instanceof Number) {
                example.setValue(newAttribute, ((Number)result).doubleValue());
                continue;
            }
            if (result instanceof Complex) {
                example.setValue(newAttribute, ((Complex)result).doubleValue());
                continue;
            }
            if (result instanceof Date) {
                example.setValue(newAttribute, ((Date)result).getTime());
                continue;
            }
            if (result instanceof Calendar) {
                example.setValue(newAttribute, ((Calendar)result).getTimeInMillis());
                continue;
            }
            if (result instanceof UnknownValue) {
                example.setValue(newAttribute, Double.NaN);
                continue;
            }
            example.setValue(newAttribute, newAttribute.getMapping().mapString(result.toString()));
        }
        return newAttribute;
    }

    public JEP getParser() {
        return this.parser;
    }

    public static List<Attribute> generateAll(LoggingHandler logging, ExampleSet exampleSet, InputStream in) throws IOException, GenerationException {
        LinkedList<Attribute> generatedAttributes = new LinkedList<Attribute>();
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        }
        catch (SAXException e1) {
            throw new IOException(e1.getMessage());
        }
        catch (ParserConfigurationException e1) {
            throw new IOException(e1.getMessage());
        }
        Element constructionsElement = document.getDocumentElement();
        if (!constructionsElement.getTagName().equals("constructions")) {
            throw new IOException("Outer tag of attribute constructions file must be <constructions>");
        }
        NodeList constructions = constructionsElement.getChildNodes();
        for (int i = 0; i < constructions.getLength(); ++i) {
            Node node = constructions.item(i);
            if (!(node instanceof Element)) continue;
            Element constructionTag = (Element)node;
            String tagName = constructionTag.getTagName();
            if (!tagName.equals("attribute")) {
                throw new IOException("Only <attribute> tags are allowed for attribute description files, but found " + tagName);
            }
            String attributeName = constructionTag.getAttribute("name");
            String attributeConstruction = constructionTag.getAttribute("construction");
            ExpressionParser parser = new ExpressionParser(true);
            if (attributeName == null) {
                throw new IOException("<attribute> tag needs 'name' attribute.");
            }
            if (attributeConstruction == null) {
                throw new IOException("<attribute> tag needs 'construction' attribute.");
            }
            if (attributeConstruction.equals(attributeName)) {
                Attribute presentAttribute = exampleSet.getAttributes().get(attributeName);
                if (presentAttribute != null) {
                    generatedAttributes.add(presentAttribute);
                    continue;
                }
                throw new GenerationException("No such attribute: " + attributeName);
            }
            generatedAttributes.add(parser.addAttribute(exampleSet, attributeName, attributeConstruction));
        }
        return generatedAttributes;
    }

    static {
        LinkedList<FunctionDescription> operatorFunctions = new LinkedList<FunctionDescription>();
        operatorFunctions.add(new FunctionDescription("+", "Addition", "Calculates the addition of the two terms surrounding this operator; example: att1 + 7", 2));
        operatorFunctions.add(new FunctionDescription("-", "Subtraction", "Calculates the subtraction of the first term by the second one; example: 42 - att2", 2));
        operatorFunctions.add(new FunctionDescription("*", "Multiplication", "Calculates the multiplication of the two terms surrounding this operator; example: 5 * att3", 2));
        operatorFunctions.add(new FunctionDescription("/", "Division", "Calculates the division of the first term by the second one; example: 12 / 4", 2));
        operatorFunctions.add(new FunctionDescription("^", "Power", "Calculates the first term to the power of the second one; example: 2^3", 2));
        operatorFunctions.add(new FunctionDescription("%", "Modulus", "Calculates the modulus of the first term by the second one; example: 11 % 2", 2));
        operatorFunctions.add(new FunctionDescription("<", "Less Than", "Delivers true if the first term is less than the second; example: att1 < 4", 2));
        operatorFunctions.add(new FunctionDescription(">", "Greater Than", "Delivers true if the first term is greater than the second; example: att2 > 3", 2));
        operatorFunctions.add(new FunctionDescription("<=", "Less Equals", "Delivers true if the first term is less than or equal to the second; example: att3 <= 5", 2));
        operatorFunctions.add(new FunctionDescription(">=", "Greater Equals", "Delivers true if the first term is greater than or equal to the second; example: att4 >= 4", 2));
        operatorFunctions.add(new FunctionDescription("==", "Equals", "Delivers true if the first term is equal to the second; example: att1 == att2", 2));
        operatorFunctions.add(new FunctionDescription("!=", "Not Equals", "Delivers true if the first term is not equal to the second; example: att1 != att2", 2));
        operatorFunctions.add(new FunctionDescription("!", "Boolean Not", "Delivers true if the following term is false or vice versa; example: !(att1 > 2)", 1));
        operatorFunctions.add(new FunctionDescription("&&", "Boolean And", "Delivers true if both surrounding terms are true; example: (att1 > 2) && (att2 < 4)", 2));
        operatorFunctions.add(new FunctionDescription("||", "Boolean Or", "Delivers true if at least one of the surrounding terms is true; example: (att1 < 3) || (att2 > 1)", 2));
        FUNCTIONS.put(FUNCTION_GROUPS[0], operatorFunctions);
        LinkedList<FunctionDescription> logFunctions = new LinkedList<FunctionDescription>();
        logFunctions.add(new FunctionDescription("ln()", "Natural Logarithm", "Calculates the logarithm of the argument to the base e; example: ln(5)", 1));
        logFunctions.add(new FunctionDescription("log()", "Logarithm Base 10", "Calculates the logarithm of the argument to the base 10; example: log(att1)", 1));
        logFunctions.add(new FunctionDescription("ld()", "Logarithm Base 2", "Calculates the logarithm of the argument to the base 2; example: ld(att2)", 1));
        logFunctions.add(new FunctionDescription("exp()", "Exponential", "Calculates the value of the constant e to the power of the argument; example: exp(att3)", 1));
        logFunctions.add(new FunctionDescription("pow()", "Power", "Calculates the first term to the power of the second one; example: pow(att1, 3)", 2));
        FUNCTIONS.put(FUNCTION_GROUPS[1], logFunctions);
        LinkedList<FunctionDescription> trigonometricFunctions = new LinkedList<FunctionDescription>();
        trigonometricFunctions.add(new FunctionDescription("sin()", "Sine", "Calculates the sine of the given argument; example: sin(att1)", 1));
        trigonometricFunctions.add(new FunctionDescription("cos()", "Cosine", "Calculates the cosine of the given argument; example: cos(att2)", 1));
        trigonometricFunctions.add(new FunctionDescription("tan()", "Tangent", "Calculates the tangent of the given argument; example: tan(att3)", 1));
        trigonometricFunctions.add(new FunctionDescription("asin()", "Arc Sine", "Calculates the inverse sine of the given argument; example: asin(att1)", 1));
        trigonometricFunctions.add(new FunctionDescription("acos()", "Arc Cos", "Calculates the inverse cosine of the given argument; example: acos(att2)", 1));
        trigonometricFunctions.add(new FunctionDescription("atan()", "Arc Tangent", "Calculates the inverse tangent of the given argument; example: atan(att3)", 1));
        trigonometricFunctions.add(new FunctionDescription("atan2()", "Arc Tangent 2", "Calculates the inverse tangent based on the two given arguments; example: atan(att1, 0.5)", 2));
        trigonometricFunctions.add(new FunctionDescription("sinh()", "Hyperbolic Sine", "Calculates the hyperbolic sine of the given argument; example: sinh(att2)", 1));
        trigonometricFunctions.add(new FunctionDescription("cosh()", "Hyperbolic Cosine", "Calculates the hyperbolic cosine of the given argument; example: cosh(att3)", 1));
        trigonometricFunctions.add(new FunctionDescription("tanh()", "Hyperbolic Tangent", "Calculates the hyperbolic tangent of the given argument; example: tanh(att1)", 1));
        trigonometricFunctions.add(new FunctionDescription("asinh()", "Inverse Hyperbolic Sine", "Calculates the inverse hyperbolic sine of the given argument; example: asinh(att2)", 1));
        trigonometricFunctions.add(new FunctionDescription("acosh()", "Inverse Hyperbolic Cosine", "Calculates the inverse hyperbolic cosine of the given argument; example: acosh(att3)", 1));
        trigonometricFunctions.add(new FunctionDescription("atanh()", "Inverse Hyperbolic Tangent", "Calculates the inverse hyperbolic tangent of the given argument; example: atanh(att1)", 1));
        FUNCTIONS.put(FUNCTION_GROUPS[2], trigonometricFunctions);
        LinkedList<FunctionDescription> statisticalFunctions = new LinkedList<FunctionDescription>();
        statisticalFunctions.add(new FunctionDescription("round()", "Round", "Rounds the given number to the next integer. If two arguments are given, the first one is rounded to the number of digits indicated by the second argument; example: round(att1) or round(att2, 3)", 2));
        statisticalFunctions.add(new FunctionDescription("floor()", "Floor", "Calculates the next integer less than the given argument; example: floor(att3)", 1));
        statisticalFunctions.add(new FunctionDescription("ceil()", "Ceil", "Calculates the next integer greater than the given argument; example: ceil(att1)", 1));
        statisticalFunctions.add(new FunctionDescription("avg()", "Average", "Calculates the average of the given arguments; example: avg(att1, att3)", -1));
        statisticalFunctions.add(new FunctionDescription("min()", "Minimum", "Calculates the minimum of the given arguments; example: min(0, att2, att3)", -1));
        statisticalFunctions.add(new FunctionDescription("max()", "Maximum", "Calculates the maximum of the given arguments; example: max(att1, att2)", -1));
        FUNCTIONS.put(FUNCTION_GROUPS[3], statisticalFunctions);
        LinkedList<FunctionDescription> textFunctions = new LinkedList<FunctionDescription>();
        textFunctions.add(new FunctionDescription("str()", "To String", "Transforms the given number into a string (nominal value); example: str(17)", 1));
        textFunctions.add(new FunctionDescription("parse()", "To Number", "Transforms the given string (nominal value) into a number by parsing it; example: parse(att2)", 1));
        textFunctions.add(new FunctionDescription("cut()", "Cut", "Cuts the substring of given length at the given start out of a string; example: cut(\"Text\", 1, 2) delivers \"ex\"", 3));
        textFunctions.add(new FunctionDescription("concat()", "Concatenation", "Concatenates the given arguments (the + operator can also be used for this); <br>example: both concat(\"At\", \"om\") and \"At\" + \"om\" deliver \"Atom\"", -1));
        textFunctions.add(new FunctionDescription("replace()", "Replace", "Replaces the first occurence of a search string by the defined replacement; <br>example: replace(att1, \"am\", \"pm\") replaces the first \"am\" in each value of attribute att1 by \"pm\"", 3));
        textFunctions.add(new FunctionDescription("replaceAll()", "Replace All", "Replaces all occurences of a search string by the defined replacement; <br>example: replaceAll(att1, \"am\", \"pm\") replaces all \"am\" in each value of attribute att1 by \"pm\"", 3));
        textFunctions.add(new FunctionDescription("lower()", "Lower", "Transforms the given argument into lower case characters; example: lower(att2)", 1));
        textFunctions.add(new FunctionDescription("upper()", "Upper", "Transforms the given argument into upper case characters; example: upper(att3)", 1));
        textFunctions.add(new FunctionDescription("index()", "Index", "Delivers the first position of the given search string in the text; example: index(\"Text\", \"e\") delivers 1", 2));
        textFunctions.add(new FunctionDescription("length()", "Length", "Delivers the length of the given argument; example: length(att1)", 1));
        textFunctions.add(new FunctionDescription("char()", "Character At", "Delivers the character at the specified position; example: char(att2, 3)", 2));
        textFunctions.add(new FunctionDescription("compare()", "Compare", "Compares the two arguments and deliver a negative value, if the first argument is lexicographically smaller; example: compare(att2, att3)", 2));
        textFunctions.add(new FunctionDescription("contains()", "Contains", "Delivers true if the second argument is part of the first one; example: contains(att1, \"pa\")", 2));
        textFunctions.add(new FunctionDescription("equals()", "Equals", "Delivers true if the two arguments are lexicographically equal to each other; example: equals(att1, att2)", 2));
        textFunctions.add(new FunctionDescription("starts()", "Starts With", "Delivers true if the first argument starts with the second; example: starts(att1, \"OS\")", 2));
        textFunctions.add(new FunctionDescription("ends()", "Ends With", "Delivers true if the first argument ends with the second; example: ends(att2, \"AM\")", 2));
        textFunctions.add(new FunctionDescription("matches()", "Matches", "Delivers true if the first argument matches the regular expression defined by the second argument; example: matches(att3, \".*mm.*\"", 2));
        textFunctions.add(new FunctionDescription("finds()", "Finds", "Delivers true if, and only if, a subsequence of the first matches the regular expression defined by the second argument; example: finds(att3, \".*AM.*|.*PM.*\"", 2));
        textFunctions.add(new FunctionDescription("suffix()", "Suffix", "Delivers the suffix of the specified length; example: suffix(att1, 2)", 2));
        textFunctions.add(new FunctionDescription("prefix()", "Prefix", "Delivers the prefix of the specified length; example: prefix(att2, 3)", 2));
        textFunctions.add(new FunctionDescription("trim()", "Trim", "Removes all leading and trailing white space characters; example: trim(att3)", 1));
        textFunctions.add(new FunctionDescription("escape_html()", "Escape HTML", "Escapes the given string with HTML entities; example: escape_html(att1)", 1));
        FUNCTIONS.put(FUNCTION_GROUPS[4], textFunctions);
        LinkedList<FunctionDescription> dateFunctions = new LinkedList<FunctionDescription>();
        dateFunctions.add(new FunctionDescription("date_parse()", "Parse Date", "Parses the given string or double to a date; example: date_parse(att1)", 1));
        dateFunctions.add(new FunctionDescription("date_parse_loc()", "Parse Date with Locale", "Parses the given string or double to a date with the given locale (via lowercase two-letter ISO-639 code); <br>example: date_parse(att1, en)", 2));
        dateFunctions.add(new FunctionDescription("date_parse_custom()", "Parse Custom Date", "Parses the given date string to a date using a custom pattern and the given locale (via lowercase two-letter ISO-639 code); <br>example: date_parse_custom(att1, \"dd|MM|yy\", \"de\")", 3));
        dateFunctions.add(new FunctionDescription("date_before()", "Date Before", "Determines if the first date is strictly earlier than the second date; example: date_before(att1, att2)", 2));
        dateFunctions.add(new FunctionDescription("date_after()", "Date After", "Determines if the first date is strictly later than the second date; example: date_after(att1, att2)", 2));
        dateFunctions.add(new FunctionDescription("date_str()", "Date to String", "Changes a date to a string using the specified format; example: date_str(att1, DATE_FULL, DATE_SHOW_DATE_AND_TIME)", 3));
        dateFunctions.add(new FunctionDescription("date_str_loc()", "Date to String with Locale", "Changes a date to a string using the specified format and the given locale (via lowercase two-letter ISO-639 code); <br>example: date_str_loc(att1, DATE_MEDIUM, DATE_SHOW_TIME_ONLY, \"us\")", 4));
        dateFunctions.add(new FunctionDescription("date_str_custom()", "Date to String with custom pattern", "Changes a date to a string using the specified custom format pattern and the (optional) given locale (via lowercase two-letter ISO-639 code); <br>example: date_str_custom(att1, \"dd|MM|yy\", \"us\")", 4));
        dateFunctions.add(new FunctionDescription("date_now()", "Create Date", "Creates the current date; example: date_now()", 0));
        dateFunctions.add(new FunctionDescription("date_diff()", "Date Difference", "Calculates the elapsed time between two dates. Locale and time zone arguments are optional; example: date_diff(timeStart, timeEnd, \"us\", \"America/Los_Angeles\")", 4));
        dateFunctions.add(new FunctionDescription("date_add()", "Add Time", "Allows to add a custom amount of time to a given date. Note that only the integer portion of a given value will be used! <br>Locale and Timezone arguments are optional; example: date_add(date, value, DATE_UNIT_DAY, \"us\", \"America/Los_Angeles\")", 5));
        dateFunctions.add(new FunctionDescription("date_set()", "Set Time", "Allows to set a custom value for a portion of a given date, e.g. set the day to 23. Note that only the integer portion of a given value will be used! <br>Locale and Timezone arguments are optional; example: date_set(date, value, DATE_UNIT_DAY, \"us\", \"America/Los_Angeles\")", 5));
        dateFunctions.add(new FunctionDescription("date_get()", "Get Time", "Allows to get a portion of a given date, e.g. get the day of a month only. Locale and Timezone arguments are optional; example: date_get(date, DATE_UNIT_DAY, \"us\", \"America/Los_Angeles\")", 4));
        FUNCTIONS.put(FUNCTION_GROUPS[5], dateFunctions);
        LinkedList<FunctionDescription> processFunctions = new LinkedList<FunctionDescription>();
        processFunctions.add(new FunctionDescription("param()", "Parameter", "Delivers the specified parameter of the specified operator; example: param(\"Read Excel\", \"file\")", 2));
        FUNCTIONS.put(FUNCTION_GROUPS[6], processFunctions);
        LinkedList<FunctionDescription> miscellaneousFunctions = new LinkedList<FunctionDescription>();
        miscellaneousFunctions.add(new FunctionDescription("if()", "If-Then-Else", "Delivers the result of the second argument if the first one is evaluated to true and the result of the third argument otherwise; <br>example: if(att1 > 5, 7 * att1, att2 / 2)", 3));
        miscellaneousFunctions.add(new FunctionDescription("const()", "Constant", "Delivers the argument as numerical constant value; example: const(att1)", 1));
        miscellaneousFunctions.add(new FunctionDescription("sqrt()", "Square Root", "Delivers the square root of the given argument; example: sqrt(att2)", 1));
        miscellaneousFunctions.add(new FunctionDescription("sgn()", "Signum", "Delivers -1 or +1 depending on the signum of the argument; example: sgn(-5)", 1));
        miscellaneousFunctions.add(new FunctionDescription("rand()", "Random", "Delivers a random number between 0 and 1; example: rand()", 0));
        miscellaneousFunctions.add(new FunctionDescription("mod()", "Modulus", "Calculates the modulus of the first term by the second one; example: 11 % 2", 2));
        miscellaneousFunctions.add(new FunctionDescription("sum()", "Sum", "Calculates the sum of all arguments; example: sum(att1, att3, 42)", -1));
        miscellaneousFunctions.add(new FunctionDescription("binom()", "Binomial", "Calculates the binomial coefficients; example: binom(5, 2)", 2));
        miscellaneousFunctions.add(new FunctionDescription("missing()", "Missing", "Checks if the given number is missing; example: missing(att1)", 1));
        FUNCTIONS.put(FUNCTION_GROUPS[7], miscellaneousFunctions);
    }
}

