/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.distribution.kernel;

import com.rapidminer.tools.math.distribution.EmpiricalNormalDistribution;

public class NormalKernel
extends EmpiricalNormalDistribution {
    public static final long serialVersionUID = -320543538793918L;
    private double minimumBandwidth;

    public NormalKernel(double minimumBandwidth) {
        this.minimumBandwidth = minimumBandwidth;
    }

    @Override
    protected void updateDistributionProperties() {
        if (this.recentlyUpdated) {
            this.mean = this.sum / this.totalWeightSum;
            double stdDev = this.totalWeightSum > 1.0 ? Math.sqrt((this.squaredSum - this.sum * this.sum / this.totalWeightSum) / (this.totalWeightSum - 1.0)) : Double.MIN_VALUE;
            this.standardDeviation = stdDev > this.minimumBandwidth ? stdDev : this.minimumBandwidth;
            this.recentlyUpdated = false;
        }
    }
}

